% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_info.R
\name{AFNIMetaInfo}
\alias{AFNIMetaInfo}
\title{Create AFNI Format Metadata Object}
\usage{
AFNIMetaInfo(descriptor, afni_header)
}
\arguments{
\item{descriptor}{AFNIFormat object specifying file format details}

\item{afni_header}{List containing AFNI header information}
}
\value{
An AFNIMetaInfo object
}
\description{
Creates an AFNIMetaInfo object containing format-specific metadata
  for AFNI format neuroimaging files.
}
\details{
Create AFNIMetaInfo Object


The AFNIMetaInfo object extends MetaInfo with AFNI-specific features:
\itemize{
  \item AFNI brick structure
  \item Sub-brick labels and scaling
  \item Space transformation
  \item Statistical parameters
}

The function handles:
\itemize{
  \item Dimension extraction and validation
  \item Label generation for sub-bricks
  \item Transformation from AFNI to NIFTI space
  \item Data type and scaling setup
}
}
\keyword{internal}
