% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.gap.R
\name{spectral_gap}
\alias{spectral_gap}
\title{Spectral gap of a graph}
\usage{
spectral_gap(g, method = "frac")
}
\arguments{
\item{g}{igraph object}

\item{method}{A string, either "frac" or "abs"}
}
\value{
Numeric value
}
\description{
The spectral (or eigen) gap of a graph is the absolute
difference between the biggest and second biggest eigenvalue
of the adjacency matrix. To compare spectral gaps across networks, the fraction can be used.
}
\details{
The spectral gap is bounded between 0 and 1 if \code{method="frac"}. The closer
the value to one, the bigger the gap.
}
\examples{
# The fractional spectral gap of a threshold graph is usually close to 1
g <- threshold_graph(50, 0.3)
spectral_gap(g, method = "frac")
}
\author{
David Schoch
}
