% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_flux_gradient_layer.R
\name{compute_flux_gradient_layer}
\alias{compute_flux_gradient_layer}
\title{Computes Fick's law of diffusion between two values}
\usage{
compute_flux_gradient_layer(depths, co2, co2_err, diffus, diffus_err)
}
\arguments{
\item{depths}{Required. Depths that the compute the flux (2 values)}

\item{co2}{Required. CO2 molar concentration (2 values, corresponding to depths)}

\item{co2_err}{Required. Error in co2 (2 values, corresponding to depths)}

\item{diffus}{Required. Diffusivity (a single value)}

\item{diffus_err}{Required. Diffusive error (a single value)}
}
\value{
Tibble of depth, flux, and error.  The depth is the mean between the depths
}
\description{
Computes Fick's law of diffusion between two values
}
\examples{
compute_flux_gradient_layer(depths = c(-0.03,-0.09),
co2 = c(28030, 66834.66),
co2_err = c(1327,1246),
diffus = 7.13e-06,
diffus_err = 3.44e-6
)

}
