% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.indvars.R
\name{neg.indvars}
\alias{neg.indvars}
\alias{print.neg.indvars}
\title{Negligible Effect Test for Variances of Independent Populations}
\usage{
neg.indvars(dv, iv, eps = 0.5, alpha = 0.05, na.rm = TRUE, data = NULL, ...)

\method{print}{neg.indvars}(x, ...)
}
\arguments{
\item{dv}{Outcome Variable}

\item{iv}{Independent Variable}

\item{eps}{Used to Establish the Equivalence Bound (Conservative: .25; Liberal: .50, according to Wellek, 2010)}

\item{alpha}{Nominal Type I Error Rate}

\item{na.rm}{Missing Data Treatment}

\item{data}{Dataset containing dv and iv}

\item{...}{Extra arguments}

\item{x}{object of class \code{neg.indvars}}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{vars} Sample variances
  \item \code{sds} Sample standard deviations
  \item \code{mads} Sample median absolute deviations
  \item \code{ratio} Ratio of the largest to smallest variance
  \item \code{eps} Epsilon (e) can be described as the maximum difference in the variances that one would consider to be unimportant (see Details).
  \item \code{LWW_md} Levene-Wellek-Welch statistic based on the median.
  \item \code{crit_LWW_md} Critical value for the Levene-Wellek-Welch statistic based on the median.
  \item \code{alpha} Nominal Type I error rate
}
}
\description{
This function allows researchers to test whether the difference
in the variances of independent populations is negligible, where
negligible represents the smallest meaningful effect size (MMES, where
in this case the effect is the difference in population variances)
}
\details{
This function evaluates whether the difference in the population variances of J independent groups can be considered negligible (i.e., the population variances can be considered equivalent).

The user provides the name of the outcome/dependent variable (should be continuous) and the name of Independent Variable (predictor, should be a factor), as well as the epsilon value (eps) which determines the smallest difference in variances that can be considered non-negligible.

Wellek (2010) suggests liberal and conservative values of eps = .50 and eps = .25, respectively. See Wellek, 2010, pp. 16, 17, 22, for details.

See Mara & Cribbie (2018): https://doi.org/10.1080/00220973.2017.1301356
}
\examples{
#Two Group Example
indvar<-rep(c("a","b"),c(10,12))
depvar<-rnorm(22)
d<-data.frame(indvar,depvar)
neg.indvars(depvar,indvar)
neg.indvars(dv=depvar,iv=indvar,eps=.25,data=d)
neg.indvars(dv=depvar,iv=indvar,eps=.5)

#Four Group Example
indvar<-rep(c("a","b","c","d"),c(10,12,15,13))
depvar<-rnorm(50)
d<-data.frame(indvar,depvar)
neg.indvars(dv=depvar,iv=indvar,eps=.25,data=d)
neg.indvars(dv=depvar,iv=indvar)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Constance Mara \email{Constance.Mara@cchmc.org}
}
