% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nm_table.R
\name{read_nm_table}
\alias{read_nm_table}
\title{Read NONMEM table files produced.}
\usage{
read_nm_table(
  nm_table,
  only_obs = FALSE,
  method = "default",
  quiet = TRUE,
  sim_num = FALSE,
  sim_name = "NSIM",
  verbose = FALSE
)
}
\arguments{
\item{nm_table}{The NONMEM table file to read. A text string. If \code{dplyr}
and \code{readr} are available and \code{method="default"} or
\code{method="readr_*"} then \code{nm_table} can either a path to a file, a
connection, or literal data (either a single string or a raw vector). Files
ending in .gz, .bz2, .xz, or .zip will be automatically uncompressed. Files
starting with http://, https://, ftp://, or ftps:// will be automatically
downloaded. Remote gz files can also be automatically downloaded &
decompressed.}

\item{only_obs}{Should the non-observation lines in the data set be removed? 
Currently filtered using the expected \code{MDV} column. \code{TRUE} or 
\code{FALSE}.}

\item{method}{Can be one of \code{default}, \code{readr_1},  \code{readr_2}, 
\code{readr_3}, \code{slow}. \code{readr_1} should be fastest.  All but 
\code{slow} require \code{\link[dplyr]{dplyr}} and 
\code{readr} (version >= 0.2.2).}

\item{quiet}{Should there be verbose messages about what the function is 
doing?}

\item{sim_num}{Should the function add a column to the returned data frame 
that identifies the simulation number (if present)?}

\item{sim_name}{The name of the resulting column in the returned data frame if \code{sim_num} is true.}

\item{verbose}{Should the output be more verbose for error checking?}
}
\value{
Returns a data frame of the simulated table with an added column for 
  the simulation number. The data frame is given class \code{c("tbl_df", 
  "tbl", "data.frame")} for easy use with \code{\link[dplyr]{dplyr}}.
}
\description{
The function reads in NONMEM table files.  The files can be created from the 
\code{$EST} line or from the \code{$SIM} line in a NONMEM model file.
}
\details{
Currently the function searches the \code{$TABLE} for multiple header lines, 
and uses that to identify multiple simulations. The function expects at least
one header line  (\code{NOHEADER} option is not allowed in NONMEM table 
files).
}
