% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-xform.R
\name{fit_xform_brain}
\alias{fit_xform_brain}
\title{Fit a single transform to a bridging registration between brains}
\usage{
fit_xform_brain(
  sample,
  reference,
  via = NULL,
  type = c("affine", "rigid", "similarity", "tps"),
  pts = NULL,
  npts = if (is.null(pts)) 1000 else NULL,
  scale = c(1, 1),
  ...
)
}
\arguments{
\item{sample}{Source template brain (e.g. IS2) that data is currently in.
Specified either as character vector or a \code{templatebrain} object.}

\item{reference}{Target template brain (e.g. IS2) that data should be
transformed into.}

\item{via}{(optional) intermediate template brain that the registration
sequence must pass through.}

\item{type}{A character string specifying the type of registration. See
\code{Morpho::computeTransform} for details.}

\item{pts}{Optional set of points to use for the fit. If they are not
specified they will be randomly sampled (see details).}

\item{npts}{Number of points to use for fit (defaults to 1000 when no
\code{pts} argument is specified).}

\item{scale}{a 2-vector indicating the amount to scale the sample and
reference points. You can supply one vector if this is the same. If the
transform expects points in microns and returns points in microns then you
would need \code{scale=c(1000,1)} if you want the input to be in microns
and the output to be in nm.}

\item{...}{Additional arguments passed to \code{\link{fit_xform}}}
}
\value{
A homogeneous affine matrix or a \code{nat::tpsreg} object
  n.b. only in development nat (>= 1.10.1)
}
\description{
Fit a single transform to a bridging registration between brains
}
\details{
If \code{pts} are supplied these will be used to construct the fit.
  This might be useful if you are focussing on a particular brain region and
  supply relevant neurons. But if you want to work with one registration to
  use for the whole brain then it's better to use points across the brain.

  When points are not provided then \code{fit_xform_brain} will first check
  to see if it can find a neuropil surface model for the \code{sample}. If it
  can, it will sample a number of points that lie inside the surface model.
  If no surface model can be found, then it will look for a
  \code{\link{templatebrain}} object specifying a bounding box around the
  sample brain. If successful, it will sample \code{npts} within that
  bounding box. If not there will be an error and you will have to supply the
  points.
}
\examples{
\dontrun{
library(nat.flybrains)
t1=fit_xform_brain(sample='FCWB', reference="JFRC2", type='affine')
t1
# the same but for points in nm
fit_xform_brain(sample='FCWB', reference="JFRC2", type='affine', scale=1000)
# run the fit based on a particular group of Kenyon cells
t2=fit_xform_brain(sample='FCWB', reference="JFRC2",
  pts=nat::kcs20, npts=300, type='affine')

nclear3d()
mfrow3d(1, 2, sharedMouse = TRUE)
plot3d(JFRC2)
plot3d(xform(FCWB.surf, t1))
next3d()
plot3d(JFRC2)
plot3d(xform(FCWB.surf, t2))
# the whole brain surfaces clearly match better when you fit on the whole brain
}
}
\seealso{
\code{\link{fit_xform}}
}
