% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apod_metadata.R
\name{get_apod_metadata}
\alias{get_apod_metadata}
\title{Retrieve Astronomy Picture of the Day (APOD) images and metadata}
\usage{
get_apod_metadata(
  start_date,
  end_date,
  api_key = "DEMO_KEY",
  folder_name = NULL
)
}
\arguments{
\item{start_date}{Character. Start date for the query in "YYYY-MM-DD" format.}

\item{end_date}{Character. End date for the query in "YYYY-MM-DD" format.}

\item{api_key}{Character. NASA API key. Defaults to "DEMO_KEY", but a personal API key is recommended.}

\item{folder_name}{Character or NULL. Folder name to save images on Desktop if provided. If NULL, images are only printed and not saved.}
}
\value{
A data frame containing metadata about the APOD images (date, title, explanation, URL, and media type).
}
\description{
Queries NASA's Astronomy Picture of the Day (APOD) API to retrieve images and metadata
between a specified start and end date. Only image media types are included.
}
\details{
The function filters out any media types that are not images—for example, videos.
It prints the image along with a truncated explanation for each entry,
then returns the full metadata as a data frame.
}
\examples{
\dontrun{
# Retrieve APOD images for a date range
apod_metadata <- get_apod_metadata(
  start_date = "2024-04-01",
  end_date = "2024-04-02",
  api_key = "DEMO_KEY"
)
}

}
