% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screeners.R
\name{screener_t_test}
\alias{screener_t_test}
\title{t-test Based Screening: Thresholds on p.values and/or t statistics}
\usage{
screener_t_test(
  data,
  formula,
  p_value_threshold = NULL,
  t_statistic_threshold = NULL
)
}
\arguments{
\item{data}{a dataset with variables mentioned in the \code{formula}}

\item{formula}{a \code{formula} with terms from \code{data}, intended to be used with a
learner from \code{nadir}.}

\item{p_value_threshold}{A numeric scalar where terms pass if the t test for
the linear model coefficient has p value lower than or equal to the
\code{p_value_threshold} given.}

\item{t_statistic_threshold}{A numeric scalar where terms pass if they have a t test
statistic greater than or equal to the \code{t_statistic_threshold} given.}
}
\value{
A list of \code{$data} with columns screened out,
\code{$formula} with variables screened out, and \code{$failed_to_pass_threshold}
the names of variables that failed to associate with the outcome at least at the threshold
level.
}
\description{
Screens out variables from the formula and dataset based on a p.value and/or
the absolute value of the t statistic from a univariate linear regression
(with intercept and one term) comparing each predictor to the outcome
(dependent) variable.
}
\details{
The intended use of \code{screener_t_test} and other screeners is for
pragmatic purposes: when there are a very large number of candidate
predictors, such that \code{super_learner} is very slow to run, predictor
variables that fail to have a detectable association with the dependent
variable of a formula should be dropped from the learner.
}
\seealso{
screeners, add_screener, screener_cor_top_n
}
