% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-special.R
\name{erf}
\alias{erf}
\alias{erf,numeric-method}
\alias{erf,dualr-method}
\title{Error function}
\usage{
erf(x)

\S4method{erf}{numeric}(x)

\S4method{erf}{dualr}(x)
}
\arguments{
\item{x}{A numeric or dual value.}
}
\value{
The error function value. For dual input, returns a dual with
derivative \eqn{(2/\sqrt{\pi}) e^{-x^2}}.
}
\description{
Computes \eqn{\mathrm{erf}(x) = \frac{2}{\sqrt{\pi}} \int_0^x e^{-t^2} dt}.
}
\examples{
erf(1)
x <- dual_variable(1)
value(erf(x))
}
