% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-higher.R
\name{dual_constant_n}
\alias{dual_constant_n}
\title{Create a constant dual for n-th order differentiation}
\usage{
dual_constant_n(x, order)
}
\arguments{
\item{x}{A numeric value.}

\item{order}{A non-negative integer specifying the nesting depth.}
}
\value{
A (possibly nested) dual number with zero derivatives.
}
\description{
Wraps a numeric value as a nested dual with all derivative components
zero, representing a constant with respect to the differentiation
variable at nesting depth \code{n}.
}
\examples{
k <- dual_constant_n(5, order = 3)
deriv_n(k, 1)
deriv_n(k, 2)
deriv_n(k, 3)
}
