% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.R
\name{dual-atan2}
\alias{dual-atan2}
\alias{atan2,dualr,dualr-method}
\alias{atan2,dualr,numeric-method}
\alias{atan2,numeric,dualr-method}
\title{Two-argument arctangent for dual numbers}
\usage{
\S4method{atan2}{dualr,dualr}(y, x)

\S4method{atan2}{dualr,numeric}(y, x)

\S4method{atan2}{numeric,dualr}(y, x)
}
\arguments{
\item{y}{A dual or numeric.}

\item{x}{A dual or numeric.}
}
\value{
A dual representing atan2(y, x) with correct derivative.
}
\description{
Two-argument arctangent for dual numbers
}
\examples{
y <- dual_variable(1)
x <- dual_constant(1)
result <- atan2(y, x)
value(result)

}
