% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.myrror}
\alias{print.myrror}
\title{Print method for Myrror object.}
\usage{
\method{print}{myrror}(x, ...)
}
\arguments{
\item{x}{an object of class 'myrror_object'}

\item{...}{additional arguments}
}
\value{
Invisibly returns the myrror object \code{x}. Called for side effects (printing comparison report to console).
}
\description{
Print method for Myrror object.
}
\examples{
# Create example datasets
dfx <- data.frame(id = 1:5,
                  name = c("A", "B", "C", "D", "E"),
                  value = c(10, 20, 30, 40, 50))

dfy <- data.frame(id = 1:6,
                  name = c("A", "B", "C", "D", "E", "F"),
                  value = c(10, 20, 35, 40, 50, 60))

# Create a myrror object
library(myrror)
m <- myrror(dfx, dfy, by.x = "id", by.y = "id")

# Print the myrror object (happens automatically)
m

# Create object with different print settings
\donttest{
# With interactive mode disabled
m2 <- myrror(dfx, dfy, by.x = "id", by.y = "id", interactive = FALSE)
print(m2)
}

}
