% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialTIME_summary_functions.R
\name{spatialTIME_summary_functions}
\alias{spatialTIME_summary_functions}
\title{\code{spatialTIME} summary function extraction}
\usage{
spatialTIME_summary_functions(
  mxFDAobject,
  metric = "uni k",
  markers = NULL,
  r_range = 0:100,
  num_permutations = 50,
  edge_correction = "trans",
  permute = TRUE,
  workers = 1,
  xloc = "x",
  yloc = "y"
)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA} for which to calculate summary functions}

\item{metric}{string vector with combination of uni/bi k/g}

\item{markers}{column names of spatial}

\item{r_range}{vector of radii to calculate metrics}

\item{num_permutations}{integer for the number of permutations to perform}

\item{edge_correction}{character vector of length 1 or 2 depending on the metrics for edge corrections to perform}

\item{permute}{logical whether to permute CSR or not. Required \code{TRUE} for Nearest Neighbor G}

\item{workers}{integer for number of cores to use to calculate derived variables}

\item{xloc, yloc}{columns in the spatial data which to use for point locations}
}
\value{
\code{mxFDA} object with the summary function slots filled according to input metric
}
\description{
\code{spatialTIME} summary function extraction
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
# example code

}
\author{
Alex Soupir \email{alex.soupir@moffitt.org}
}
\keyword{internal}
