% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mvgam.R
\name{summary.mvgam}
\alias{summary.mvgam}
\alias{summary.mvgam_prefit}
\alias{coef.mvgam}
\title{Summary for a fitted \pkg{mvgam} models}
\usage{
\method{summary}{mvgam}(object, include_betas = TRUE, smooth_test = TRUE, digits = 2, ...)

\method{summary}{mvgam_prefit}(object, ...)

\method{coef}{mvgam}(object, summarise = TRUE, ...)
}
\arguments{
\item{object}{\code{list} object returned from \code{mvgam}}

\item{include_betas}{Logical. Print a summary that includes posterior
summaries of all linear predictor beta coefficients (including spline
coefficients)? Defaults to \code{TRUE} but use \code{FALSE} for a more
concise summary}

\item{smooth_test}{Logical. Compute estimated degrees of freedom and
approximate p-values for smooth terms? Defaults to \code{TRUE}, but users
may wish to set to \code{FALSE} for complex models with many smooth or
random effect terms}

\item{digits}{The number of significant digits for printing out the summary;
defaults to \code{2}.}

\item{...}{Ignored}

\item{summarise}{\code{logical}. Summaries of coefficients will be returned
if \code{TRUE}. Otherwise the full posterior distribution will be returned}
}
\value{
For \code{summary.mvgam}, an object of class \code{mvgam_summary} containing:
\itemize{
\item \code{model_spec}: Model specification details (formulas, family, dimensions)
\item \code{parameters}: Parameter estimates and significance tests
\item \code{diagnostics}: MCMC convergence diagnostics
\item \code{sampling_info}: Sampling algorithm details
}

For \code{summary.mvgam_prefit}, a \code{list} is printed on-screen showing
the model specifications

For \code{coef.mvgam}, either a \code{matrix} of posterior coefficient
distributions (if \code{summarise == FALSE} or \code{data.frame} of
coefficient summaries)
}
\description{
These functions take a fitted \code{mvgam} or \code{jsdgam} object and
return various useful summaries
}
\details{
\code{summary.mvgam} and \code{summary.mvgam_prefit} return brief summaries of
the model's call, along with posterior intervals for some of the key
parameters in the model. Note that some smooths have extra penalties on the
null space, so summaries for the \code{rho} parameters may include more
penalty terms than the number of smooths in the original model formula.
Approximate p-values for smooth terms are also returned, with methods used
for their calculation following those used for \code{mgcv} equivalents (see
\code{\link[mgcv]{summary.gam}} for details). The Estimated Degrees of
Freedom (edf) for smooth terms is computed using either \code{edf.type = 1} for
models with no trend component, or \code{edf.type = 0} for models with trend
components. These are described in the documentation for
\code{\link[mgcv]{jagam}}. Experiments suggest these p-values tend to be
more conservative than those that might be returned from an equivalent model
fit with \code{\link[mgcv]{summary.gam}} using \code{method = 'REML'}

\code{coef.mvgam} returns either summaries or full posterior estimates for \code{GAM}
component coefficients
}
\examples{
\dontrun{
simdat <- sim_mvgam(seasonality = "hierarchical")

mod <- mvgam(
  y ~ series +
    s(season, bs = "cc", k = 6) +
    s(season, series, bs = "fs", k = 4),
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

mod_summary <- summary(mod)
mod_summary
}
}
\author{
Nicholas J Clark
}
