% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepares the data to be used by the \code{mutual} function}
\usage{
prepare_data(data, vars, fw = NULL, col.order = NULL)
}
\arguments{
\item{data}{A tabular object: \code{data.frame}, \code{data.table} or
\code{tibble}.}

\item{vars}{A vector of column names or indices, or the literal
\code{"all_vars"} to select every column except \code{fw}.}

\item{fw}{(optional) Name or index of the frequency-weight column.
Must reference exactly one column. If \code{NULL}, a new variable
\code{fw = 1} is created.}

\item{col.order}{(optional) Column(s) used to sort the final table;
must be included in \code{vars}. Accepts names or indices.}
}
\value{
A \code{data.table} with classes \code{"mutual.data"},
  \code{"data.frame"} and \code{"data.table"}.
  The analytical variables are stored in the attribute \code{"vars"};
  the key is cleared.
}
\description{
Takes a tabular object (micro-data or a frequency table) and returns a
\code{data.table} ready for \code{mutual}.
The output
* stores every analytical variable as a \code{factor};
* holds the weight variable under the unified name \code{fw} (numeric);
* aggregates identical combinations (summing their weights) and drops rows
  where \code{fw == 0}.
}
\examples{
\donttest{
md <- prepare_data(
  DF_Seg_Chile,
  vars = c("csep", "ethnicity", "school", "district"),
  fw   = "nobs"
)
md <- prepare_data(DF_Seg_Chile, vars = "all_vars")
class(md)
}

}
