% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{loudnessMapping}
\alias{loudnessMapping}
\title{Loudness Mapping.}
\usage{
loudnessMapping(x, lMin = 18, lMax = 141, qtrans = NULL, ...)
}
\arguments{
\item{x}{Vector or data frame, series to be mapped}

\item{lMin}{Integer, minimum loudness (default corresponds to ppp)}

\item{lMax}{Integer, maximum loudness (default corresponds to fff)}

\item{qtrans}{function, quantile transformation to be applied before mapping
For instance data can be "normalized" by using qnorm.}

\item{...}{further arguments to be passed to qtrans.}
}
\value{
A vector of numerics representing loudnesses.
}
\description{
Map a series of values into a series of loudnesses
}
\examples{
l <- loudnessMapping(x=rnorm(100))
}
