% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projector.R
\name{projector}
\alias{projector}
\title{Construct a \code{projector} instance}
\usage{
projector(v, preproc = prep(pass()), ..., classes = NULL)
}
\arguments{
\item{v}{A matrix of coefficients with dimensions \code{nrow(v)} by \code{ncol(v)} (columns = components)}

\item{preproc}{A prepped pre-processing object (S3 class \code{pre_processor}). Default is the no-op \code{pass()} preprocessor.}

\item{...}{Extra arguments to be stored in the \code{projector} object.}

\item{classes}{Additional class information used for creating subtypes of \code{projector}. Default is NULL.}
}
\value{
An instance of type \code{projector}.
}
\description{
A \code{projector} maps a matrix from an N-dimensional space to d-dimensional space, where \code{d} may be less than \code{N}.
The projection matrix, \code{v}, is not necessarily orthogonal. This function constructs a \code{projector} instance which can be
used for various dimensionality reduction techniques like PCA, LDA, etc.
}
