% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process.R
\name{concat_pre_processors}
\alias{concat_pre_processors}
\title{bind together blockwise pre-processors}
\usage{
concat_pre_processors(preprocs, block_indices)
}
\arguments{
\item{preprocs}{a list of initialized \code{pre_processor} objects}

\item{block_indices}{a list of integer vectors specifying the global column indices for each block}
}
\value{
a new \code{pre_processor} object that applies the correct transformations blockwise
}
\description{
concatenate a sequence of pre-processors, each applied to a block of data.
}
\examples{

p1 <- center() |> prep()
p2 <- center() |> prep()

x1 <- rbind(1:10, 2:11)
x2 <- rbind(1:10, 2:11)

p1a <- init_transform(p1,x1)
p2a <- init_transform(p2,x2)

clist <- concat_pre_processors(list(p1,p2), list(1:10, 11:20))
t1 <- apply_transform(clist, cbind(x1,x2))

t2 <- apply_transform(clist, cbind(x1,x2[,1:5]), colind=1:15)
}
