% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{stack_bpg}
\alias{stack_bpg}
\title{Stacks data in the style of Bauer-Preacher-Gil for multilevel mediation}
\usage{
stack_bpg(data, L2ID, X, Y, M,
  moderator = NULL,
  covars.m = NULL,
  covars.y = NULL)
}
\arguments{
\item{data}{Data frame in long format.}

\item{L2ID}{(String) Name of column that contains grouping variable in \code{data} (e.g., \code{"SubjectID"}).}

\item{X}{(String) Name of column that contains the X independent variable in \code{data}.}

\item{Y}{(String) Name of column that contains the Y dependent variable in \code{data}.}

\item{M}{(String) Name of column that contains the M mediating variable in \code{data}.}

\item{moderator}{Optional Character that contains name of column that contains the moderator variable in \code{data}}

\item{covars.m}{(Character vector) Optional covariates to include in the model for M.}

\item{covars.y}{(Character vector) Optional covariates to include in the model for Y.}
}
\value{
An object that is a subclass of \code{data.frame} is returned. In particular a \code{tbl_df} or "tibble."


So that coefficients extracted later from \code{\link{modmed.mlm}} hopefully make more sense, the below lists all variables
  (i.e., typical column names) for the data frame.

\itemize{
 \item{\code{X} Independent variable.}
 \item{\code{L2id} Level 2 ID variable.}
 \item{\code{Md} Value of the mediator (not necessarily used due to restructuring, however).}
 \item{\code{Outcome} Whether the row corresponds to M or Y as the outcome.}
 \item{\code{Z} Value of the outcome variable.}
 \item{\code{Sy} Indicator variable for Y as outcome. 0 if Y is not outcome for this row. 1 if Y is outcome for this row. In model output, this is the intercept for Y.}
 \item{\code{Sm} Indicator variable for M as outcome. 0 if M is not outcome for this row. 1 if M is outcome for this row. In model output, this is the intercept for M.}
 \item{\code{SmX} Value of X when M is the outcome (literally X times Sm); will be 0 when Y is outcome. In model output, this is the "a" path.}
 \item{\code{SyX} Value of X when Y is the outcome (literally X times Sy); will be 0 when M is outcome. In model output, this is the "cprime" path (direct effect).}
 \item{\code{SyM} Calue of M when Y is the outcome (literally M times Sy); will be 0 when M is the outcome. In model output, this is the "b" path.}
 \item{\code{W} Value of any moderating variable. This may show up in output later on as "SmX:W" (interaction with "a" path) or "SyM:W" (interaction with "b" path) or "SyX:W"
    (interaction with "cprime" path) depending on which path it moderates.}
 \item{If \code{covars.m} or \code{covars.y} are not null, any additional covariates will also be added to the data frame and their
    original names will be retained.}
}

When \code{\link{modmed.mlm}} is used, any output with an "re" prefix will correspond to a random effect. Note that estimation with brms
will result in slightly different output than listed here. Coefficients typically have a "b_" prefix, and random effects are parameterized not
such that we end up with covariances, but using correlations and standard deviations for each effect.
}
\description{
Stacks data in the style of Bauer-Preacher-Gil for multilevel mediation
}
\details{
This is a convenience function used primarily internally by the package to restructure data in the style of
  Bauer, Preacher, and Gil (2006). The point is to allow both Y and M to be outcomes in a single column ("Z"),
  so that both mediator and outcome models can be fit at the same time. This is necessary to estimate the covariance
  between "a" and "b" paths at the same time when both have random effects. Two selector variables, "Sy" and "Sm" toggle
  whether each row corresponds to the outcome or the mediator, respectively.
}
\examples{
\donttest{

# restructure BPG data
data(BPG06dat)

dat <- stack_bpg(BPG06dat,
  "id", "x", "y", "m"
)

head(dat)

# restructure simulated data w/ moderator
data(simdat)
dat2 <- stack_bpg(simdat,
  "L2id", "X", "Y", "M",
  moderator = "mod"
)

head(dat2)

}
}
\references{
Bauer, D. J., Preacher, K. J., & Gil, K. M. (2006). Conceptualizing and testing random indirect effects and moderated mediation in multilevel models: new procedures and	recommendations. Psychological Methods, 11(2), 142-163. \doi{10.1037/1082-989X.11.2.142}
}
