% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{fixef.brmcoda}
\alias{fixef.brmcoda}
\alias{fixef}
\title{Population-Level Estimates}
\usage{
\method{fixef}{brmcoda}(object, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{...}{Further arguments passed to \code{\link[brms:fixef.brmsfit]{fixef.brmsfit}}.}
}
\value{
If \code{summary} is \code{TRUE}, a matrix returned
  by \code{\link[brms]{posterior_summary}} for the population-level effects.
  If \code{summary} is \code{FALSE}, a matrix with one row per
  posterior draw and one column per population-level effect.
}
\description{
Extract the population-level ('fixed') effects
from the \code{brmsfit} object in a \code{brmcoda} object.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  ## fit a model
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
               formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                                  wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
                                  chain = 1, iter = 500,
                                  backend = "cmdstanr")

  ## extract population-Level coefficients
  fixef(m)
}}
}
\seealso{
\code{\link[brms:fixef.brmsfit]{fixef.brmsfit}}
}
