% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mland_load.R
\name{mland_load}
\alias{mland_load}
\title{Load 'MultiLand' or 'MultiLandMetrics' object}
\usage{
mland_load(path, ...)
}
\arguments{
\item{path}{A string depicting the path to a zip file, to load objects of class
'MultiLand', or to a RDS file to load objects of class 'MultiLandMetrics'.}

\item{...}{Other parameters passed to \code{\link[=readRDS]{readRDS()}} when trying to load an object of class
'MultiLandMetrics'.}
}
\value{
A 'MultiLand' or a 'MultiLandMetrics' object.
}
\description{
Imports a zip file into an object of class 'MultiLand' that was previously
saved with \code{\link[=mland_save]{mland_save()}}. Alternatively, loads to the environment an RDS object depicting a
'MultiLandMetrics' object.
}
\examples{
# Loads mland object from a zip file, previously created with mland_save()
mland_obj <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign <- mland_load(mland_obj)

# Loads a MultiLandMetrics object previously generated with mland_metrics() and
# exported as a RDS object with mland_save() or saveRDS()

mlm_obj <- system.file("extdata", "ed_metrics.rds", package = "multilandr")
ed_metrics <- mland_load(mlm_obj)
}
\seealso{
\code{\link[=mland_save]{mland_save()}}, \code{\link[=mland]{mland()}}, \code{\link[=mland_metrics]{mland_metrics()}}
}
