% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_filter.R
\name{metrics_filter}
\alias{metrics_filter}
\title{Filters metrics}
\usage{
metrics_filter(x, conditions, output = "MLM")
}
\arguments{
\item{x}{An object of class 'MultiLandMetrics' generated with \code{\link[=mland_metrics]{mland_metrics()}}.}

\item{conditions}{List. Conditions to be met by the landscapes. See Details.}

\item{output}{One of the following: "MLM" to return an updated version of the 'MultiLandMetrics' object provided in \code{x} (default),
"spatial" to return a 'SpatVector' with the points
of the selected landscapes, "data" to return a data.frame with the metric values information or "coords"
to return a data.frame with geographical information of the filtered points.}
}
\value{
A 'MultiLandMetrics' if \code{output = "MLM"}, a 'SpatVector' if \code{output = "spatial"},
a data.frame if \code{output = "data"} or a data.frame with geographical information of the points if \code{output = "coords"}.
}
\description{
Selects landscapes that meet certain pre-defined conditions in relation to its metrics from
a 'MultiLandMetrics' object.
}
\details{
Selects landscapes that meet certain conditions in relation to the values of
their landscape metrics. The function will retain those points associated with the landscapes
that meet all the defined conditions at the same time. Conditions must be provided through a list,
for which the helper function \code{\link[=conditions]{conditions()}} is available:

\preformatted{
 conditions(list(rasterlayers, class, radii, metric, minimum value, maximum value),
            list(rasterlayers, class, radii, metric, minimum value, maximum value),
            ...)
}
\itemize{
\item rasterlayers: the raster layers to be considered. If NA, all raster layers will be considered. If
an extra raster layer must be specified, the string "ext" must precede the raster layer number
(e.g. "ext1", "ext2").
\item class: the classes to be considered, as numbers or strings with the names of the classes. If NA, all classes of required raster layers will be
considered. If NULL, the function will assume that the metric to be considered is a landscape-level metric.
Take into account that metrics from extra calculations are considered as landscape-level metrics.
\item radii: the radii to be considered. If NA, all radii will be considered.
\item metrics: the name of the metric to be considered (as defined with its abbreviation by column "metric" in \code{\link[=metrics_list]{metrics_list()}}).
Only one metric per condition can be defined. Metrics as extra calculations for extra raster layers must be
provided as "fun_" + the name of the function (e.g. "fun_mean").
\item minimum value: the minimum value that the metric must have in the filtered landscapes. If equal
to -Inf, and a maximum value is defined, landscapes whose values in the defined metric are equal
or lower to the maximum value will be retained.
\item maximum value: the maximum value that the metric must have in the filtered landscapes. If equal
to Inf, and a minimum value is defined, landscapes whose values in the defined metric are equal
or higher to the minimum value will be retained.
}

A plausible list of conditions could be the following:

\preformatted{
 conditions(list(1, 2, 1000, "pland", 20, 30),
            list(1, 4, 1000, "np", 1, 15),
            list("ext1", NULL, 1000, "fun_mean", 70, 80))
}

And it would indicate that landscapes of radius equal to 1000 m should present values of "pland"
(percentage of the landscape) for class 2 from raster layer 1, between 20 and 30\%. At the same time, landscapes of radius
equal to 1000 m should present values of "np" (number of patches) for class 4 from rasterlayer 1,
between 1 and 15 patches. Finally, all selected landscapes of radius equal to 1000 m should
present values for "fun_mean" (applied to extra raster layer "ext1") between 70 and 80. Note that the
slot for "class" is NULL, as extra raster layers do not hold classes.
}
\examples{
# Filter landscapes that have between 20 and 30\% of forest at a radius of 2000 m
# and output the data.frame with metrics values
conds <- conditions(list(NA, "Forest", 2000, "pland", 20, 30))
otf_subset <- metrics_filter(otf_metrics,
                             conditions = conds,
                             output = "data")

# The same but returning a data.frame with information of the retained points
conds <- conditions(list(NA, "Forest", 2000, "pland", 20, 30))
otf_subset_points <- metrics_filter(otf_metrics,
                                    conditions = conds,
                                    output = "coords")

# Filter landscapes that have between 20 and 30\% of forest at a radius of 2000 m
# and a maximum of 60\% of Crops.
conds <- conditions(list(NA, "Forest", 2000, "pland", 20, 30),
                    list(NA, "Crops", 2000, "pland", -Inf, 60))
otf_subset2 <- metrics_filter(otf_metrics,
                              conditions = conds,
                              output = "data")
}
\seealso{
\code{\link[=metrics_gradient]{metrics_gradient()}}
}
