#' @importFrom methods is show
#' @importClassesFrom terra SpatVector

setClassUnion("null_chr", c("NULL", "character"))

#' Class "MultiLand"
#'
#' Objects of class 'MultiLand' are created with the function [mland()], and holds
#' relevant objects and information to be passed to other functions of the package. The slot
#' `@buffers` holds an object of class 'SpatVector' with the buffers for each point
#' contained in the slot `@points` and each radius defined in slot `@radii`. The slot
#' `@buffers@data` holds a data.frame with the identification of each buffer (individualized by a
#'  point id and a radius value).
#'
#'  If the slot `@on_the_fly` equals `FALSE`, the slot `@landscapes` holds the intersections (objects of class 'SpatRaster') between
#'  buffers and the raster layers inputted by the user when running [mland()]. Intersections
#'  between buffers and raster layers with discrete values (inputted in argument `raster` in [mland()]) are
#'  contained inside a list named 'lsm_rasters', whereas intersections between extra raster layers
#'  (inputted in argument `ext_rast_layer` in [mland()]) and buffers
#'  are contained inside a list named 'ext_rasters'. Each list ('lsm_rasters' and 'ext_rasters') contains a
#'  list with as many elements as previously inputted raster layers. Additionally, each element of
#'  this latter list holds an additional internal list, with as many elements as intersections (i.e. rasters generated by the intersections between buffers defined
#'  by each point and radius, and the raster layer). The name of each element of each internal list
#'  reveals the information related to a given intersection, with the following coding: "RasterLayerL-P-R" or
#'  "ExtRasterLayerL-P-R", where L is the
#'  given raster layer, P is the id of the point and R is the radius. For example, a plausible
#'  intersection may be named as "RasterLayer1-5-1500", indicating that this element holds a raster
#'  layer which is the result of the intersection between RasterLayer1 and the buffer around point 5 and
#'  radius 1500 m.
#'
#'  If slot `@on_the_fly` equals `FALSE`, the slot `@landscapes` holds a list containing two named lists
#'  as 'lsm_rasters' and 'ext_rasters'. Each one contains a list with as many raster layers were initially
#'  inputted by the user when running [mland()] in arguments `rast_layer` and `ext_rast_layer`.
#'  This means that no intersections were
#'  made when creating the 'MultiLand' object. Intersections will be created "on the fly" when other functions of
#'  the package requires them.
#'
#' @slot call The call when function [mland()] was called.
#' @slot idkey A unique identification id for the 'MultiLand' object.
#' @slot crs_proj A string depicting the CRS of points layer.
#' @slot points An object of class 'SpatVector'. Holds the points inputted by the user.
#' @slot buffers An object of class 'SpatVector'. Holds the buffers layers.
#' @slot site_ref String holding the name of the attribute that the user defined as
#' the one that identifies individual points and is contained inside the layer of points.
#' @slot radii Vector of numbers containing the radii that defined the creation of buffers.
#' @slot n_layers Number of raster layers (defined in argument `raster` in [mland()]) from which i
#' ntersections between were created (or will be if slot `@on_the_fly = TRUE`).
#' @slot n_classes A numeric vector depicting the number of classes (raster values) per raster
#' layer (defined in argument `raster` in [mland()]).
#' @slot classes A data.frame depicting the classes (and classes names) for each rasterlayer
#' (defined in argument `raster` in [mland()]).
#' @slot on_the_fly A logical value indicating whether intersections between buffers and raster layers
#' were created (FALSE) or not (TRUE).
#' @slot landscapes If `on_the_fly = FALSE`, this slot holds the intersections between buffers and
#' raster layers. Otherwise, if `on_the_fly = TRUE`, it holds the raw raster layers.
#' @slot l_ref A data.frame relating each point and radius with a "row_id", equal to the position of
#' its buffer in the slot `@buffers` and to the position of the intersection for each point/radius in
#' the slot `@landscapes` (if `on_the_fly = TRUE`).
#' @slot rast_names A list containing two data.frame with the names assigned by the user for the main raster layers
#' and extra raster layers defined in argument `rast_layer` and `ext_rast_layer` in [mland()].
#'
#' @examples
#' # Shows information of object 'MultiLand'
#' ernesdesign <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
#' ernesdesign <- mland_load(ernesdesign)
#' ernesdesign
#' @export
setClass("MultiLand",

         slots = c(
           # call
           call = "call",

           # MultiLand id
           idkey = "numeric",

           # CRS proj
           crs_proj = "character",

           # number of layers
           n_layers = "numeric",

           # number of classes per layer,
           n_classes = "numeric",

           # classes per layer,
           classes = "data.frame",

           # points
           points = "SpatVector",

           # buffers
           buffers = "SpatVector",

           # on the fly?
           on_the_fly = "logical",

           # landscapes
           landscapes = "list",

           # main rasters and extra rasters names
           rast_names = "list",

           # data.frame reference
           l_ref = "data.frame",

           # sites reference
           site_ref = "null_chr",

           # radii
           radii = "numeric")
         )

#' Class 'MultiLandMetrics'
#'
#' Objects of class `MultiLandMetrics` are returned by [mland_metrics()]. It holds all the information
#' relative to the metrics that were calculated by the parameters inputted by the user. This object
#' class can be passed to functions [metrics_corr()], [metrics_plots()], [metrics_filter()], [metrics_gradient()] and
#' [metrics_bind()] for further analyses.
#'
#' @slot call The call when function [mland_metrics()] was called.
#' @slot idkey A unique identification id for the 'MultiLandMetrics' object.
#' @slot crs_proj A string depicting the CRS of points layer.
#' @slot n_layers Number of raster layers from which metrics were calculated.
#' @slot rast_names A list with dataframes containing the names of the raster layers of the
#' 'MultiLand' object the function [mland_metrics()] worked with.
#' @slot classes A data.frame depicting the raster layers, classes and classes names from which
#' metrics were calculated.
#' @slot n_classes Numeric vector depicting the number of distinct classes per raster layer
#' from which metrics were calculated.
#' @slot points A data.frame containing points coordinates and other attributes.
#' @slot n_points Number of points from which metrics were calculated.
#' @slot site_names Logical. Whether points have associated site names or not.
#' @slot radii Distinct radii from which metrics were calculated.
#' @slot metrics A data.frame depicting the metrics that were calculated, classified by level.
#' @slot data Main data.frame with the values of the metrics that were calculated for each
#' point, radius, raster layers and other parameters pre-defined by the user.
#' @slot ext_calcs A data.frame depicting the extra calculations that were made in given extra
#' raster layers.
#'
#' @export
#'
#' @examples
#' # Shows information of object 'MultiLandMetrics'
#' ed_metrics
#' otf_metrics
setClass("MultiLandMetrics",

         slots = c(
           # call
           call = "call",

           # Multilandmetrics id
           idkey = "numeric",

           # CRS proj
           crs_proj = "character",

           # number of raster layers
           n_layers = "numeric",

           # raster layers names
           rast_names = "list",

           # classes
           classes = "data.frame",

           # number of classes per layer,
           n_classes = "numeric",

           # points
           points = "data.frame",

           # number of points
           n_points = "numeric",

           # site names
           site_names = "logical",

           # radii
           radii = "numeric",

           # metrics
           metrics = "data.frame",

           # extra calculations for extra rasters
           ext_calcs = "data.frame",

           # data frame of metric values
           data = "data.frame")
        )
