% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSizeAtTime.R
\name{getSizeAtTime}
\alias{getSizeAtTime}
\title{Calculate outbreak size at a given time}
\usage{
getSizeAtTime(time, transmrates, recoveryrate, popsize, initR, initI, initV)
}
\arguments{
\item{time}{the time at which to calculate the outbreak size}

\item{transmrates}{matrix of group-to-group (column-to-row) transmission rates}

\item{recoveryrate}{inverse of mean infectious period}

\item{popsize}{the population size of each group}

\item{initR}{initial number of each group already infected and removed (included in size result)}

\item{initI}{initial number of each group infectious}

\item{initV}{initial number of each group vaccinated}
}
\value{
a list with totalSize (total cumulative infections) and activeSize (total currently infected) in each group at the specified time
}
\description{
Calculate outbreak size at a given time
}
\examples{
getSizeAtTime(time = 30, transmrates = matrix(0.2, 2 ,2), recoveryrate = 0.3,
popsize = c(100, 150), initR = c(0, 0), initI = c(0, 1), initV = c(10, 10))
}
