% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\alias{block.preprocess}
\title{Preprocessing of block data}
\usage{
block.preprocess(
  X,
  block = 1:length(X),
  fun = c("autoscale", "center", "scale", "SNV", "EMSC", "Fro", "FroSq", "SingVal"),
  ...
)
}
\arguments{
\item{X}{\code{data.frame} or \code{list} of data.}

\item{block}{\code{vector} of block(s) to preprocess (\code{integer}s or \code{character}s).}

\item{fun}{\code{character} or \code{function} selecting which preprocessing to apply (see Details).}

\item{...}{additional arguments to underlying functions.}
}
\value{
The input multiblock object is preprocessed and returned.
}
\description{
This is an interface to simplify preprocessing of one, a subset or all
blocks in a multiblock object, e.g., a \code{data.frame} (see \code{block.data.frame})
or \code{list}. Several standard preprocessing methods are supplied in addition to
letting the user supply it's own function.
}
\details{
The \code{fun} parameter controls the type of preprocessing to be performed:
\itemize{
\item autoscale: centre and scale each feature/variable.
\item center: centre each feature/variable.
\item scale: scale each feature/variable.
\item SNV: Standard Normal Variate correction, i.e., centre and scale each sample across features/variables.
\item EMSC: Extended Multiplicative Signal Correction defaulting to basic EMSC (2nd order polynomials). Further parameters are sent to \code{EMSC::EMSC}.
\item Fro: Frobenius norm scaling of whole block.
\item FroSq: Squared Frobenius norm scaling of whole block (sum of squared values).
\item SingVal: Singular value scaling of whole block (first singular value).
\item User defined: If a function is supplied, this will be applied to chosen blocks.
Preprocessing can be done for all blocks or a subset. It can also be done in a series of operations to combine preprocessing techniques.
}
}
\examples{
data(potato)
# Autoscale Chemical block
potato <- block.preprocess(potato, block = "Chemical", "autoscale")
# Apply SNV to NIR blocks
potato <- block.preprocess(potato, block = 3:4, "SNV")
# Centre Sensory block
potato <- block.preprocess(potato, block = "Sensory", "center")
# Scale all blocks to unit Frobenius norm
potato <- block.preprocess(potato, fun = "Fro")

# Effect of SNV
NIR <- (potato$NIRraw + rnorm(26)) * rnorm(26,1,0.2)
NIRc <- block.preprocess(list(NIR), fun = "SNV")[[1]]
old.par <- par(mfrow = c(2,1), mar = c(4,4,1,1))
matplot(t(NIR), type="l", main = "uncorrected", ylab = "")
matplot(t(NIRc), type="l", main = "corrected", ylab = "")
par(old.par)

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
