% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{prior}
\alias{prior}
\alias{prior_h}
\alias{prior_M}
\alias{prior_q}
\title{Priors for MSA model}
\usage{
prior_h(MSAdata, s = 1, m, stdev)

prior_M(MSAdata, s = 1, meanlog, sdlog)

prior_q(MSAdata, i = 1, meanlog, sdlog)
}
\arguments{
\item{MSAdata}{Data object. Class \linkS4class{MSAdata}}

\item{s}{Integer for stock}

\item{m}{Mean in un-transformed space}

\item{stdev}{Standard deviation in un-transformed space}

\item{meanlog}{Mean of the lognormal distribution on the log scale}

\item{sdlog}{Standard of the lognormal distribution on the log scale}

\item{i}{Integer for the corresponding index}
}
\value{
Character.
}
\description{
Priors in MSA are set by providing character strings which are then parsed into an expression and evaluated in the model environment
(see example). This provides flexibility to set a prior for any desired model parameter or variable. See list of parameters in the
documentation for \verb{[check_parameters()]} for options (note that priors for \code{log_rdev_ys} and \code{log_initrdev_as} are not needed as they're hard-coded into the model).
Several functions below generate the character string for the prior for important dynamics parameters, such as natural mortality and steepness.
}
\details{
\itemize{
\item \code{prior_h} returns the log prior for stock-recruit steepness. Beta distribution for the Beverton-Holt function and normal distribution for Ricker function.
}

\itemize{
\item \code{prior_M} returns the log prior for natural mortality. Lognormal distribution.
}

\itemize{
\item \code{prior_q} returns the log prior for index catchability. Lognormal distribution.
}
}
\examples{
# Add M and steepness prior to model

dat <- new("MSAdata")
dat@Dmodel@ns <- 1
dat@Dstock@SRR_s <- "BH"

pr_M <- prior_M(dat, s = 1, log(0.25), 0.3)
pr_h <- prior_h(dat, s = 1, 0.8, 0.15)
dat@Dmodel@prior <- c(pr_M, pr_h)
}
