% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{conv_mov}
\alias{conv_mov}
\title{Calculate movement matrix for all age classes}
\usage{
conv_mov(x, g, v, na = dim(x)[1], nr = dim(x)[2], aref = ceiling(0.5 * na))
}
\arguments{
\item{x}{Base log-movement parameters. See details. Array \verb{[a, r, r]}}

\item{g}{Gravity model attractivity term. Tendency to move to region \code{r}. Matrix \verb{[a, r]}}

\item{v}{Gravity model viscosity term. Tendency to stay in same region. Vector by \code{a}}

\item{na}{Integer, number of ages}

\item{nr}{Integer, number of regions}

\item{aref}{Integer, reference age class}
}
\value{
Movement array \verb{[a, r, r]}
}
\description{
Movement matrices are calculated for all age classes from a base matrix and a gravity model formulation
(Carruthers et al. 2016).
}
\details{
Rows index region of origin and columns denote region of destination.

In log space, the movement matrix \eqn{m_a} for age class \eqn{a} from region \eqn{r} to \eqn{r'} is the sum of base matrix \eqn{x} and
gravity matrix \eqn{G}:
\deqn{m_{a,r,r'} = x_{a,r,r'} + G_{a,r,r'}}

To essentially exclude movement from \eqn{r} to \eqn{r'}, set \eqn{x_{a,r,r'} = -1000}.

Gravity matrix \eqn{G} includes an attractivity term \eqn{g} and viscosity term \eqn{v}:

\deqn{G_{a,r,r'} =
\begin{cases}
g'_{a,r'} + v_a \quad & r = r'\\
g'_{a,r'} \quad & \textrm{otherwise}
\end{cases}
}

Vector \eqn{g'} are offset terms relative to the value for the reference age class:
\deqn{g'_{a,r'} =
\begin{cases}
g_{a,r} \quad & a = a_{ref}\\
g_{a,r} + g_{a=aref,r} \quad & \textrm{otherwise}
\end{cases}
}

The movement matrix in normal space is obtained by the softmax transformation:
\deqn{M_{a,r,r'} = \dfrac{\exp(m_{a,r,r'})}{\sum_{r'}\exp(m_{a,r,r'})}}

If \eqn{x} and \eqn{v} are zero, then the movement matrix simply distributes the total stock
abundance into the various regions as specified in \eqn{g'}.
}
\references{
Carruthers, T.R., et al. 2015. Modelling age-dependent movement: an application to red and
gag groupers in the Gulf of Mexico. CJFAS 72: 1159-1176. \doi{10.1139/cjfas-2014-0471}
}
