% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_Utility.R
\name{Utility}
\alias{Utility}
\title{Utility Model}
\usage{
Utility(params)
}
\arguments{
\item{params}{Parameters used by the model’s internal functions,
see \link[multiRL]{params}}
}
\value{
Depending on the \code{mode} and \code{estimate} defined in the 
   runtime environment, the corresponding outputs for different estimation 
   methods are produced, such as a single log-likelihood value or summary 
   statistics.
}
\description{
Learning Rate: \eqn{\alpha}
 
 \deqn{Q_{new} = Q_{old} + \alpha \cdot (U(R) - Q_{old})}
 
 Inverse Temperature: \eqn{\beta}
 
 \deqn{
   P_{t}(a) = 
   \frac{
     \exp(\beta \cdot Q_{t}(a))
   }{
     \sum_{i=1}^{k} \exp(\beta \cdot Q_{t}(a_{i}))
   }
 }
 
 Stevens' Power-law Exponent: \eqn{\gamma}
 
 \deqn{U(R) = {R}^{\gamma}}
}
\section{Body}{
 
\preformatted{Utility <- function(params){
  
  params <- list(
    free = list(alpha = params[1], beta = params[2], gamma = params[3])
  )
  
  multiRL.model <- multiRL::run_m(
    data = data,
    behrule = behrule,
    colnames = colnames,
    params = params,
    funcs = funcs,
    priors = priors,
    settings = settings
  )
  
  assign(x = "multiRL.model", value = multiRL.model, envir = multiRL.env)
  return(.return_result(multiRL.model))
}
}
}

