% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{augmentGrid}
\alias{augmentGrid}
\title{Augment a grid of candidate designs with type 1 and type 2 error
probabilities, expected sample sizes and probabilities of early termination}
\usage{
augmentGrid(d, parallel = TRUE, cores = NA, minChunkSize = 1e+05)
}
\arguments{
\item{d}{a tibble created by `createGrid`}

\item{parallel}{use parallelisation if available}

\item{cores}{the number of cores to use when parallelising.  If
<code>NA</code>, all available cores are requested}

\item{minChunkSize}{The minimum size of the grid before paralellisation is
attempted}
}
\value{
an augmented grid tibble
}
\description{
Augment a grid of candidate designs with type 1 and type 2 error
probabilities, expected sample sizes and probabilities of early termination
}
\section{Usage Notes}{

Regardless of the value of `parallel`, parallelisation is only
used if the size of the grid is greater than <code>chunkSize</code>.  If
paralellisation is requested and needed, an exception is thrown if the
parallel package is not available.
}

\examples{
x <- createGrid(p0 = 0.1, p1 = 0.30, alpha = 0.1, beta = 0.1, nMin = 24, nMax = 32) \%>\%
  augmentGrid(parallel = FALSE)
}
