% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_demo_data.R
\name{simulate_mr_mash_data}
\alias{simulate_mr_mash_data}
\title{Simulate data to test \code{mr.mash}.}
\usage{
simulate_mr_mash_data(
  n,
  p,
  p_causal,
  r,
  r_causal = list(1:r),
  intercepts = rep(1, r),
  pve = 0.2,
  B_cor = 1,
  B_scale = 1,
  w = 1,
  X_cor = 0,
  X_scale = 1,
  V_cor = 0
)
}
\arguments{
\item{n}{scalar indicating the number of samples.}

\item{p}{scalar indicating the number of variables.}

\item{p_causal}{scalar indicating the number of causal variables.}

\item{r}{scalar indicating the number of responses.}

\item{r_causal}{a list of numeric vectors (one element for each mixture component) 
indicating in which responses the causal variables have an effect.}

\item{intercepts}{numeric vector of intercept for each response.}

\item{pve}{per-response proportion of variance explained by the causal variables.}

\item{B_cor}{scalar or numeric vector (one element for each mixture component)
with positive correlation [0, 1] between causal effects.}

\item{B_scale}{scalar or numeric vector (one element for each mixture component) with the 
diagonal value for Sigma_k;}

\item{w}{scalar or numeric vector (one element for each mixture component) with mixture 
proportions associated to each mixture component.}

\item{X_cor}{scalar indicating the positive correlation [0, 1] between variables.}

\item{X_scale}{scalar indicating the diagonal value for Gamma.}

\item{V_cor}{scalar indicating the positive correlation [0, 1] between residuals}
}
\value{
A list with some or all of the
following elements:

\item{X}{n x p matrix of variables.}

\item{Y}{n x r matrix of responses.}

\item{B}{p x r matrix of effects.}

\item{V}{r x r residual covariance matrix among responses.}
  
\item{Sigma}{list of r x r covariance matrices among the effects.} 

\item{Gamma}{p x p covariance matrix among the variables.}

\item{intercepts}{r-vector of intercept for each response.}

\item{causal_responses}{a list of numeric vectors of indexes indicating which responses have
  causal effects for each mixture component.}
  
\item{causal_variables}{p_causal-vector of indexes indicating which variables are causal.}  

\item{causal_vars_to_mixture_comps}{p_causal-vector of indexes indicating from which
  mixture components each causal effect comes.}
}
\description{
Function to simulate data from \eqn{MN_{nxr}(XB, I, V)}, where \eqn{X \sim N_p(0, Gamma)},
  \eqn{B \sim \sum_k w_k N_r(0, Sigma_k)}, with \eqn{Gamma}, \eqn{w_k}, \eqn{Sigma_k}, and \eqn{V} defined by the user.
}
\examples{
set.seed(1)
dat <- simulate_mr_mash_data(n=50, p=40, p_causal=20, r=5,
                             r_causal=list(1:2, 3:4), intercepts=rep(1, 5),
                             pve=0.2, B_cor=c(0, 1), B_scale=c(0.5, 1),
                             w=c(0.5, 0.5), X_cor=0.5, X_scale=1, 
                             V_cor=0)
                             
                             
}
