% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{split.SplicedView}
\alias{split.SplicedView}
\title{Get a list of Views from a SplicedView}
\usage{
\method{split}{SplicedView}(x, f, drop, ...)
}
\arguments{
\item{x}{\code{SplicedView} object.}

\item{f}{ignored.}

\item{drop}{ignored.}

\item{...}{ignored.}
}
\value{
list of \code{View} objects.
}
\description{
Get a list of Views from a SplicedView
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
l <- list(a = c(0, 10), b = c(10, 20), c = c(20, 30))
splicing_df <- splice_time(l)
sv <- get_spliced_view(pv, splicing_df)
v_list <- split(sv)
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{get_spliced_view}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()}
}
\concept{splicing functions}
