% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_main.R
\name{md_run}
\alias{md_run}
\title{Run study design workflow}
\usage{
md_run(design, trace = TRUE)
}
\arguments{
\item{design}{An object of class \code{movedesign} (and
\code{movedesign_input}), as returned by \code{\link[=md_prepare]{md_prepare()}}, containing
all study design parameters and data.}

\item{trace}{Logical. If TRUE (default), print progress and timing
messages to the console.}
}
\value{
An updated \code{movedesign} object (subclass
\code{movedesign_preprocess}) containing all simulation and outputs
components:
\itemize{
\item \code{simList}: List of simulated telemetry datasets,
one per individual.
\item \code{seedList}: List of random seeds used for
reproducibility.
\item \code{simfitList}: List of fitted movement models for
each simulation.
\item \code{akdeList}: List of home range (AKDE) estimates,
present if the \code{hr} target was listed in \code{set_target}.
\item \code{ctsdList}: List of continuous-time speed and
distance (CTSD) estimates, present if the \code{ctsd} target
was listed in \code{set_target}.
}
}
\description{
Executes a complete simulation and analysis workflow for an animal
movement study design prepared using \code{\link[=md_prepare]{md_prepare()}}. This function
simulates telemetry data, fits movement models, estimates home ranges
and/or movement speeds, and stores all results in the returned object.
Progress and timing messages are printed by default.
}
\details{
This function ensures reproducibility by saving all random seeds and
intermediate results. Progress and timing messages help track the
simulation workflow.

Typical workflow:
\itemize{
\item Prepare a study design with \code{\link[=md_prepare]{md_prepare()}}.
\item Run all simulations and analyses with \code{\link[=md_run]{md_run()}}.
\item Summarize or plot outputs from the returned object.
}
}
\examples{
if(interactive()) {
input <- md_prepare(
  data = buffalo,
  models = models,
  species = "buffalo",
  n_individuals = 5,
  dur = list(value = 1, unit = "month"),
  dti = list(value = 1, unit = "day"),
  add_individual_variation = TRUE,
  set_target = "hr",
  which_meta = "mean"
)
output <- md_run(input)
}

}
\seealso{
\code{\link[=md_prepare]{md_prepare()}},
\code{\link[=md_replicate]{md_replicate()}},
\code{\link[=md_check]{md_check()}},
\code{\link[=md_plot]{md_plot()}}
}
