% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{cd}
\alias{cd}
\title{Change Active Database and Schema}
\usage{
cd(.con, database_name, schema_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{A character string specifying the database to switch to.
Must be one of the available databases returned by \code{\link[=list_all_databases]{list_all_databases()}}.}

\item{schema_name}{(Optional) A character string specifying the schema
to switch to within the given database. Must be one of the available
schemas returned by \code{\link[=list_current_schemas]{list_current_schemas()}}.}
}
\value{
Invisibly returns a message summarizing the new connection context.
Side effects include printing CLI headers showing the current user
and database context.
}
\description{
Switches the active database and (optionally) schema for a valid
DuckDB or MotherDuck connection. The function validates the target
database and schema before executing the \code{USE} command and provides
user feedback via CLI messages.
}
\details{
The \code{cd()} function is analogous to a "change directory" command in a
file system, but for database contexts. It updates the currently active
database (and optionally schema) for the given connection. If the target
database or schema does not exist, the function aborts with a descriptive
CLI error message.
}
\examples{
\dontrun{
# Connect to MotherDuck
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))

# List available databases
list_databases(con)

# Change to a specific database and schema
cd(con, database_name = "analytics_db", schema_name = "public")

# Disconnect
DBI::dbDisconnect(con)
}

}
\seealso{
Other db-meta: 
\code{\link{launch_ui}()},
\code{\link{pwd}()}
}
\concept{db-meta}
