## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(mortAAR)
library(magrittr)

head(mortAAR::nitra)
nitra_prep <- prep.life.table(nitra, group = "sex", agebeg = "age_start", ageend = "age_end", agerange = "included")

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
head(mortAAR::aiterhofen_oedmuehlen)
aiterhofen_prep <- mortAAR::prep.life.table(aiterhofen_oedmuehlen, dec = "Dx", agebeg = "Alter", method = "Equal5")

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
mortAAR::life.table(aiterhofen_prep)

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
nitra_lt <- mortAAR::life.table(nitra_prep)
nitra_lt

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
plot(nitra_lt, line_vis = "colour")

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
plot(nitra_lt$All, display = "dx")

## ---- message=FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(ggplot2)
ggplot(nitra_lt$All, aes(x=c(0,cumsum(a)[-nrow(nitra_lt$All)]), y=dx)) +
 geom_point() +
 geom_line(aes(col = "All")) +
 scale_x_continuous(breaks=seq(0, 70, 10)) +
 labs(title="Nitra", x = "age", y = "dx") +
 geom_line(data=nitra_lt$m, aes(col= "male"), linewidth=1.2, linetype="dashed") +
 geom_line(data=nitra_lt$f, aes(col= "female"), linewidth=1.2, linetype="dotted") +
 scale_colour_manual(values = c("black", "blue","red")) + theme_light() +
 theme( legend.title = element_blank())

