% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_set.R
\name{model_set}
\alias{model_set}
\alias{gen_models}
\title{BIC Posterior Probabilities
of Neighboring Models}
\usage{
model_set(
  sem_out,
  partables = NULL,
  model_set_out = NULL,
  prior_sem_out = NULL,
  must_add = NULL,
  must_not_add = NULL,
  must_drop = NULL,
  must_not_drop = NULL,
  remove_constraints = TRUE,
  exclude_error_cov = TRUE,
  exclude_feedback = TRUE,
  exclude_xy_cov = TRUE,
  df_change_add = 1,
  df_change_drop = 1,
  remove_duplicated = TRUE,
  fit_models = ifelse(!is.null(model_set_out$fit), FALSE, TRUE),
  compute_bpp = TRUE,
  original = "original",
  parallel = FALSE,
  ncores = max(parallel::detectCores(logical = FALSE) - 1, 1),
  make_cluster_args = list(),
  progress = TRUE,
  verbose = TRUE,
  skip_check_sem_out = FALSE,
  drop_equivalent_models = TRUE
)

gen_models(
  sem_out,
  must_add = NULL,
  must_not_add = NULL,
  must_drop = NULL,
  must_not_drop = NULL,
  remove_constraints = TRUE,
  exclude_error_cov = TRUE,
  df_change_add = 1,
  df_change_drop = 1,
  remove_duplicated = TRUE,
  progress = TRUE,
  output = c("partables", "model_set")
)
}
\arguments{
\item{sem_out}{It can be the output
from an
SEM function. Currently it supports
\link[lavaan:lavaan-class]{lavaan::lavaan} objects only.
If it is a named list of
\link[lavaan:lavaan-class]{lavaan::lavaan} objects, then
all arguments for model generation
will be ignored, and models will not
be refitted. Users need to ensure
that the models can be meaningfully
compared because they will not be
checked.}

\item{partables}{A \code{partables}-class
object, usually generated by
\code{\link[=get_add]{get_add()}} or \code{\link[=get_drop]{get_drop()}}. A named
list of parameter tables to be fitted
along with the original model in
\code{sem_out}.
If supplied, all arguments related
to identifying models will be ignored.
Default is \code{NULL}.}

\item{model_set_out}{If set to
the output of a previous call
to \code{\link[=model_set]{model_set()}} (a \code{model_set}-class
object), the list of stored models
will be used. All arguments related
to generate neighboring models will
be ignored.
If supplied, \code{sem_out} will also be
ignored and will be retrieved from
\code{model_set_out}, and \code{partables}
will also be ignored.
Default is \code{NULL}.}

\item{prior_sem_out}{The prior of the
model fitted in \code{sem_out}. Default
is \code{NULL}, and all models will have
equal prior probabilities.}

\item{must_add}{A character vector
of parameters, named in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} style (e.g.,
\code{"y ~ x"}), that must be added.
Default is `NULL``.}

\item{must_not_add}{A character
vector of parameters, named in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} style (e.g.,
\code{"x1 ~~ x1"}), that must not be
added. Default is \code{NULL}.}

\item{must_drop}{A character vector
of parameters, named in
\code{lavaan::lavaan()} style (e.g.,
\code{"y ~ x"}), that must be included.
Default is \code{NULL}.}

\item{must_not_drop}{A character
vector of parameters, named in
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} style (e.g.,
\code{"x1 ~~ x1"}), that must not be
included. Default is \code{NULL}.}

\item{remove_constraints}{Whether
equality constraints will be
removed. Default is ``TRUE`.}

\item{exclude_error_cov}{Exclude
error covariances of indicators.
Default is \code{TRUE}.}

\item{exclude_feedback}{Exclude
paths that will result in a feedback
loop. For example, if there is
path from \code{x} through \code{m} to \code{y},
then the path \code{x ~ y} will create
a feedback loop.  Default has been
changed to
\code{TRUE} since Version 0.1.3.5 because
feedback loops are usually
not included except when theoretically
justified. To reproduce results
based on previous version, set this
argument to \code{FALSE}.}

\item{exclude_xy_cov}{Exclude
covariance between two variables,
in which one has a path to another.
For example, if there is
path from \code{x} through \code{m} to \code{y},
then the covariance \code{x ~~ y},
which denotes the covariance between
\code{x} and the error term of \code{y}, will
be excluded if this argument is
\code{TRUE}. Default has been changed to
\code{TRUE} since Version 0.1.3.5 because
these covariances rarely are
interpretable. To reproduce results
based on previous version, set this
argument to \code{FALSE}.}

\item{df_change_add}{How many degrees
of freedom (\emph{df}) away in the list.
All models with \emph{df} change less than
or equal to this number will be
included, taking into account
requirements set by other arguments.
Default is 1.}

\item{df_change_drop}{How many degrees
of freedom away in the list. All
models with \emph{df} change less than
or equal to this number will be
included, taking into account
requirements set by other arguments.
Default is 1.}

\item{remove_duplicated}{If \code{TRUE},
the default, duplicated models are
removed.}

\item{fit_models}{If \code{TRUE},
the
models will be fitted to the data,
usually stored in \code{sem_out}.
If \code{FALSE}, the models will be returned
as is, in the element \code{models}
of the output. If \code{model_set_out}
is set and models have been fitted,
then default is \code{FALSE}. Otherwise,
default is \code{TRUE}.}

\item{compute_bpp}{If \code{TRUE}, then BIC
posterior probabilities will be
computed. Default
is \code{TRUE}.}

\item{original}{String. The name of the
original (traget) model. Default is
\code{"original"}. Used if \code{prior_sem_out}
is unnamed and only has one value.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used to fit the
models. Default is \code{FALSE}.}

\item{ncores}{Numeric. The number of
CPU cores to be used if \code{parallel}
is \code{TRUE}.}

\item{make_cluster_args}{A list of
named arguments to be passed to
\code{parallel::makeCluster()}. Used by
advanced users to configure the
cluster if \code{parallel} is \code{TRUE}.
Default is \code{list()}.}

\item{progress}{Whether a progress
bar will be displayed, implemented
by the \code{pbapply} package or by
\code{utils::txtProgressBar}. Default
is \code{TRUE}.}

\item{verbose}{Whether additional
messages will be displayed, such
as the expected processing time.
Default is \code{TRUE}.}

\item{skip_check_sem_out}{If \code{TRUE}
and \code{sem_out} is set, check
whether \code{sem_out} is of a supported
type (estimator is \code{"ML"} and
the model has only one group). If
not, an error will be raised.
Can be set to \code{FALSE} for experimenting
the functions on models not officially
supported.}

\item{drop_equivalent_models}{If
\code{TRUE}, the default, equivalent
models will be dropped in the final
output. This check can only be
conducted when no models are fitted
in \code{\link[lavaan:lavaan]{lavaan::lavaan()}} with
\code{fixed.x = TRUE} (which is the
default of \code{\link[lavaan:sem]{lavaan::sem()}}).}

\item{output}{If \code{"model_set"},
then the output is a \code{model_set}-class
object. If \code{"partables"}, the output
is a \code{partables}-class object.
Default is \code{partables}.}
}
\value{
The function \code{\link[=model_set]{model_set()}}
returns an object of the class
\code{model_set}, a list with the following
major elements:
\itemize{
\item \code{models}: A named list of parameter
tables. Each represent the models
identified.
\item \code{bic}: A numeric vector, of the
same length as \code{model}. The BIC of
each model.
\item \code{postprob}: A numeric vector, of
the same length as \code{model}. The
BIC posterior probability of each
model.
\item \code{fit}: A named list of
\code{\link[lavaan:lavaan]{lavaan::lavaan()}} output objects
or \code{\link[=update]{update()}} for fitting a model
with the added parameters, of the
same length as \code{model}.
\item \code{change}: A numeric vector, of the
same length as \code{model}. The change
in model df for each fit. A
positive number denotes one less
free parameter. A negative number
denotes one more free parameter or
one less constraint.
\item \code{converged}: A named vector of
boolean values, of the same length
as \code{model}. Indicates whether each
fit converged or not.
\item \code{post_check}: A named vector of
boolean values, of the same length
as \code{model}. Indicates whether the
solution of each fit is admissible
or not. Checked by
\code{\link[lavaan:lavInspect]{lavaan::lavInspect()}}.
}

The object returned by \code{\link[=gen_models]{gen_models()}}
depends on the argument \code{output}.
See the argument \code{output} for the
details
}
\description{
Identify neighboring
models, fit them, and return the
BIC posterior probabilities.
}
\details{
It computes the BIC
posterior probabilities of a set
of models by the method presented
in Wu, Cheung, and Leung (2020).

First, a list of model is identified
based on user-specified criteria.
By default, models differ from a fitted
model by one degree of freedom,
the 1-df-away \emph{neighboring} models,
will be found using \code{\link[=get_add]{get_add()}}
and \link{get_drop}.

Second, these models will be fitted
to the sample dataset, and their
BICs will be computed.

Third, their BIC posterior
probabilities will be computed
using their BICs. By default,
equal prior
probabilities for all the models
being fitted will be assumed in
the current version. This can be
changed by \code{prior_sem_out}.

The results can then be printed,
with the models sorted by descending
order of BIC posterior
probabilities. The results can
also be visualized using
\code{\link[=model_graph]{model_graph()}}.
}
\section{Functions}{
\itemize{
\item \code{model_set()}: Compute the BPPs of a list of models.
Can generate the models and/or fit the models. Can also
accept pregenerated models, or just update BPPs.

\item \code{gen_models()}: Generate a list of models (parameter tables).

}}
\examples{

library(lavaan)

dat <- dat_path_model

mod <-
"
x3 ~ a*x1 + b*x2
x4 ~ a*x1
ab := a*b
"

fit <- sem(mod, dat_path_model, fixed.x = TRUE)

out <- model_set(fit)
out

}
\references{
Wu, H., Cheung, S. F., & Leung, S. O.
(2020). Simple use of BIC to assess
model selection uncertainty: An
illustration using mediation and
moderation models.
\emph{Multivariate Behavioral Research},
\emph{55}(1), 1--16.
\doi{10.1080/00273171.2019.1574546}
}
\seealso{
\code{\link[=print.model_set]{print.model_set()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
