% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerAsyncSuccessiveHalving.R
\name{mlr_optimizers_async_successive_halving}
\alias{mlr_optimizers_async_successive_halving}
\alias{OptimizerAsyncSuccessiveHalving}
\title{Asynchronous Hyperparameter Optimization with Successive Halving}
\source{
Li L, Jamieson K, Rostamizadeh A, Gonina E, Ben-tzur J, Hardt M, Recht B, Talwalkar A (2020).
\dQuote{A System for Massively Parallel Hyperparameter Tuning.}
In Dhillon I, Papailiopoulos D, Sze V (eds.), \emph{Proceedings of Machine Learning and Systems}, volume 2, 230--246.
\url{https://proceedings.mlsys.org/paper_files/paper/2020/hash/a06f20b349c6cf09a6b171c71b88bbfc-Abstract.html}.
}
\description{
\code{OptimizerAsyncSuccessiveHalving} class that implements the Asynchronous Successive Halving Algorithm (ASHA).
This class implements the asynchronous version of \link{OptimizerBatchSuccessiveHalving}.
}
\section{Dictionary}{

This \link[bbotk:Optimizer]{bbotk::Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[bbotk:mlr_optimizers]{bbotk::mlr_optimizers} or with the associated sugar function \code{\link[bbotk:opt]{bbotk::opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("async_successive_halving")
opt("async_successive_halving")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{eta}}{\code{numeric(1)}\cr
With every stage, the budget is increased by a factor of \code{eta} and only the best \code{1 / eta} configurations are promoted to the next stage.
Non-integer values are supported, but \code{eta} is not allowed to be less or equal to 1.}
\item{\code{sampler}}{\link[paradox:Sampler]{paradox::Sampler}\cr
Object defining how the samples of the parameter space should be drawn.
The default is uniform sampling.}
}
}

\section{Archive}{

The \link[bbotk:Archive]{bbotk::Archive} holds the following additional columns that are specific to SHA:
\itemize{
\item \code{stage} (\verb{integer(1))}\cr
Stage index. Starts counting at 0.
\item \code{asha_id} (\verb{character(1))}\cr
Unique identifier for each configuration across stages.
}
}

\section{Custom Sampler}{

Hyperband supports custom \link[paradox:Sampler]{paradox::Sampler} object for initial
configurations in each bracket.
A custom sampler may look like this (the full example is given in the
\emph{examples} section):

\if{html}{\out{<div class="sourceCode">}}\preformatted{# - beta distribution with alpha = 2 and beta = 5
# - categorical distribution with custom probabilities
sampler = SamplerJointIndep$new(list(
  Sampler1DRfun$new(params[[2]], function(n) rbeta(n, 2, 5)),
  Sampler1DCateg$new(params[[3]], prob = c(0.2, 0.3, 0.5))
))
}\if{html}{\out{</div>}}
}

\section{Super classes}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{\link[bbotk:OptimizerAsync]{bbotk::OptimizerAsync}} -> \code{OptimizerAsyncSuccessiveHalving}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerAsyncSuccessiveHalving-new}{\code{OptimizerAsyncSuccessiveHalving$new()}}
\item \href{#method-OptimizerAsyncSuccessiveHalving-optimize}{\code{OptimizerAsyncSuccessiveHalving$optimize()}}
\item \href{#method-OptimizerAsyncSuccessiveHalving-clone}{\code{OptimizerAsyncSuccessiveHalving$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerAsyncSuccessiveHalving-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerAsyncSuccessiveHalving-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerAsyncSuccessiveHalving$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerAsyncSuccessiveHalving-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerAsyncSuccessiveHalving-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the optimization on a \link[bbotk:OptimInstanceAsyncSingleCrit]{bbotk::OptimInstanceAsyncSingleCrit} or \link[bbotk:OptimInstanceAsyncMultiCrit]{bbotk::OptimInstanceAsyncMultiCrit} until termination.
The single evaluations will be written into the \link[bbotk:ArchiveAsync]{bbotk::ArchiveAsync}.
The result will be written into the instance object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerAsyncSuccessiveHalving$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link[bbotk:OptimInstanceAsyncSingleCrit]{bbotk::OptimInstanceAsyncSingleCrit} | \link[bbotk:OptimInstanceAsyncMultiCrit]{bbotk::OptimInstanceAsyncMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerAsyncSuccessiveHalving-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerAsyncSuccessiveHalving-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerAsyncSuccessiveHalving$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
