% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_fairml_classif_fairfgrrm.R
\name{mlr_learners_classif.fairfgrrm}
\alias{mlr_learners_classif.fairfgrrm}
\alias{LearnerClassifFairfgrrm}
\title{Classification Fair Generalized Ridge Regression Learner}
\description{
Calls \link[fairml:frrm]{fairml::fgrrm} from package \CRANpkg{fairml}.
}
\details{
Fair generalized ridge regression model implemented via package \code{fairml}.
The 'unfairness' parameter is set to 0.05 as a default.
}
\section{Dictionary}{
 This \link[mlr3:Learner]{mlr3::Learner} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners} or with the associated
sugar function \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("classif.fairfgrrm")
lrn("classif.fairfgrrm")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Predict Types: \dQuote{response}, \dQuote{prob}
\item Feature Types: \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{fairml}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   lambda \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   definition \tab character \tab sp-komiyama \tab sp-komiyama, eo-komiyama \tab - \cr
   save.auxiliary \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   unfairness \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   family \tab character \tab binomial \tab gaussian, binomial \tab - \cr
   intersect \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
}
}

\examples{
\dontshow{if (rlang::is_installed("fairml")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")
# stop example failing with warning if package not installed
learner = suppressWarnings(mlr3::lrn("classif.fairfgrrm"))
print(learner)

# available parameters:
learner$param_set$ids()
\dontshow{\}) # examplesIf}
}
\references{
Scutari M, Panero F, Proissl M (2021).
\dQuote{Achieving Fairness with a Simple Ridge Penalty.}
\emph{arXiv preprint arXiv:2105.13817}.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}:
\link[mlr3:mlr_learners]{mlr3::mlr_learners}

Other fairness_learners: 
\code{\link{mlr_learners_classif.fairzlrm}},
\code{\link{mlr_learners_regr.fairfrrm}},
\code{\link{mlr_learners_regr.fairnclm}},
\code{\link{mlr_learners_regr.fairzlm}}
}
\author{
pfistfl
}
\concept{fairness_learners}
\keyword{internal}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}} -> \code{LearnerClassifFairfgrrm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClassifFairfgrrm-new}{\code{LearnerClassifFairfgrrm$new()}}
\item \href{#method-LearnerClassifFairfgrrm-clone}{\code{LearnerClassifFairfgrrm$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="selected_features"><a href='../../mlr3/html/Learner.html#method-Learner-selected_features'><code>mlr3::Learner$selected_features()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifFairfgrrm-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifFairfgrrm-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifFairfgrrm$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifFairfgrrm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifFairfgrrm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifFairfgrrm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
