% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_tree.R
\name{validate_tree}
\alias{validate_tree}
\title{Validate a Transmission Tree}
\usage{
validate_tree(tree)
}
\arguments{
\item{tree}{A data frame with columns \code{from} and \code{to} representing the transmission tree.}
}
\value{
Invisible \code{TRUE} if the tree is valid. Throws an error if invalid.
}
\description{
Checks if a transmission tree meets specific topology criteria for our test.
The tree must be a directed acyclic graph (DAG), weakly connected, and have at most one infector per node.
}
\examples{
good_tree <- data.frame(from = c(1, 2, 3), to = c(2, 3, 4))
validate_tree(good_tree)
bad_tree <- data.frame(from = c(1, 2, 3), to = c(2, 3, 2))
try(validate_tree(bad_tree))
}
