% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve-sample-size.R
\name{mp_solve_sample_size}
\alias{mp_solve_sample_size}
\title{Solve for minimum sample size achieving target power}
\usage{
mp_solve_sample_size(
  scenario,
  parameter,
  grid,
  target_power = 0.8,
  nsim = 100,
  alpha = 0.05,
  seed = NULL,
  failure_policy = c("count_as_nondetect", "exclude"),
  conf_level = 0.95
)
}
\arguments{
\item{scenario}{An \code{mp_scenario}.}

\item{parameter}{Dotted path of the single parameter to vary (e.g. \code{"clusters.subject"}).}

\item{grid}{Numeric vector of candidate values.}

\item{target_power}{Target power threshold (default 0.8).}

\item{nsim}{Number of simulations per grid point (default 100).}

\item{alpha}{Significance level (default 0.05).}

\item{seed}{Optional seed for reproducibility.}

\item{failure_policy}{How to treat failed fits: \code{"count_as_nondetect"} or \code{"exclude"}.}

\item{conf_level}{Confidence level for power intervals (default 0.95).}
}
\value{
A list with \code{target_power}, \code{parameter}, \code{solution} (numeric: minimum
grid value achieving target power, or \code{NA} if none), and \code{results} (data
frame with estimate, failure_rate, singular_rate, n_effective, etc., per
grid point).
}
\description{
Evaluates power on a user-supplied grid of values for one parameter (e.g.
cluster size) via \code{\link[=mp_power_curve]{mp_power_curve()}}, then returns the smallest grid value
whose power estimate meets or exceeds the target. Diagnostics (failure rate,
singular rate, n_effective) are exposed in the returned \code{results} table.
}
