% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMART.R
\name{SMART}
\alias{SMART}
\title{Support-vector Margin Algoritm for Reliability esTimation}
\usage{
SMART(
  dimension,
  lsf,
  N1 = 10000,
  N2 = 50000,
  N3 = 2e+05,
  Nu = 50,
  lambda1 = 7,
  lambda2 = 3.5,
  lambda3 = 1,
  tune_cost = c(1, 10, 100, 1000),
  tune_gamma = c(0.5, 0.2, 0.1, 0.05, 0.02, 0.01),
  clusterInMargin = TRUE,
  alpha_margin = 1,
  k1 = round(6 * (dimension/2)^(0.2)),
  k2 = round(12 * (dimension/2)^(0.2)),
  k3 = k2 + 16,
  X = NULL,
  y = NULL,
  failure = 0,
  limit_fun_MH = NULL,
  sampling_strategy = "MH",
  seeds = NULL,
  seeds_eval = NULL,
  burnin = 20,
  thinning = 4,
  plot = FALSE,
  limited_plot = FALSE,
  add = FALSE,
  output_dir = NULL,
  z_MH = NULL,
  z_lsf = NULL,
  verbose = 0
)
}
\arguments{
\item{dimension}{the dimension of the input space}

\item{lsf}{the limit-state function}

\item{N1}{Number of samples for the (L)ocalisation step}

\item{N2}{Number of samples for the (S)tabilisation step}

\item{N3}{Number of samples for the (C)onvergence step}

\item{Nu}{Size of the first Design of Experiments}

\item{lambda1}{Relaxing parameter for MH algorithm at step L}

\item{lambda2}{Relaxing parameter for MH algorithm at step S}

\item{lambda3}{Relaxing parameter for MH algorithm at step C}

\item{tune_cost}{Input for tuning cost paramter of the SVM}

\item{tune_gamma}{Input for tuning gamma parameter of the SVM}

\item{clusterInMargin}{Enforce selected clusterised points to be in margin}

\item{alpha_margin}{a real value defining the margin. While
1 is the \sQuote{real} margin for a SVM, one can decide here to
stretch it a bit.}

\item{k1}{Rank of the first iteration of step S}

\item{k2}{Rank of the first iteration of step C}

\item{k3}{Rank of the last iteration of step C}

\item{X}{Coordinates of alredy known points}

\item{y}{Value of the LSF on these points}

\item{failure}{Failure threshold}

\item{limit_fun_MH}{Define an area of exclusion with a limit function}

\item{sampling_strategy}{Either MH for Metropolis-Hastings of AR for accept-reject}

\item{seeds}{If some points are already known to be in the subdomain defined
by \code{limit_fun_MH}}

\item{seeds_eval}{Value of the metamodel on these points}

\item{burnin}{Burnin parameter for MH}

\item{thinning}{Thinning parameter for MH}

\item{plot}{Set to TRUE for a full plot, ie. refresh at each iteration}

\item{limited_plot}{Set to TRUE for a final plot with final DOE, metamodel and LSF}

\item{add}{If plots are to be added to the current device}

\item{output_dir}{If plots are to be saved in jpeg in a given directory}

\item{z_MH}{For plots, if the limit_fun_MH has already been evaluated on the grid}

\item{z_lsf}{For plots, if LSF has already been evaluated on the grid}

\item{verbose}{Either 0 for almost no output, 1 for medium size output and 2
for all outputs}
}
\value{
An object of class \code{list} containing the failure probability and some more outputs as described below:
\item{proba}{The estimated failure probability.}
\item{cov}{The coefficient of variation of the Monte-Carlo probability estimate.}
\item{Ncall}{The total number of calls to the \code{limit_state_function}.}
\item{X}{The final learning database, ie. all points where \code{lsf} has been calculated.}
\item{y}{The value of the \code{limit_state_function} on the learning database.}
\item{meta_fun}{The metamodel approximation of the \code{limit_state_function}.
A call output is a list containing the value and the standard deviation.}
\item{meta_model}{The final metamodel.}
\item{points}{Points in the failure domain according to the metamodel.}
  \item{meta_eval}{Evaluation of the metamodel on these points.}
  \item{z_meta}{If \code{plot}==TRUE, the evaluation of the metamodel on the plot grid.}
}
\description{
Calculate a failure probability with SMART method. This
should not be used by itself but only through S2MART.
}
\details{
\code{SMART} is a reliability method proposed by J.-M. Bourinet et al. It makes
uses of a SVM-based metamodel to approximate the limit state function and calculates
the failure probability with a crude Monte-Carlo method using the metamodel-based
limit state function. As SVM is a classification method, it makes use of limit state
function values to create two classes : greater and lower than the failure threshold.
Then the border is taken as a surogate of the limit state function.

Concerning the refinement strategy, it distinguishes 3 stages, known as Localisation,
Stalibilsation and Convergence stages. The first one is proposed to reduce the margin
as much as possible, the second one focuses on switching points while the last one works
on the final Monte-Carlo population and is designed to insure a strong margin;
see F. Deheeger PhD thesis for more information.
}
\note{
Problem is supposed to be defined in the standard space. If not, use \code{\link{UtoX}}
to do so.

Furthermore, each time a set of vector is defined as a matrix,
\sQuote{nrow} = \code{dimension} and \sQuote{ncol} = number of vector.
}
\references{
\itemize{
\item
J.-M. Bourinet, F. Deheeger, M. Lemaire:\cr
\emph{Assessing small failure probabilities by combined Subset Simulation and Support Vector Machines}\cr
Structural Safety (2011)

\item
F. Deheeger:\cr
\emph{Couplage mecano-fiabiliste : 2SMART - methodologie d'apprentissage stochastique en fiabilite}\cr
  PhD. Thesis, Universite Blaise Pascal - Clermont II, 2008
}
}
\seealso{
\code{\link{SubsetSimulation}}
\code{\link{MonteCarlo}}
\code{\link[e1071]{svm}} (in package \pkg{e1071})
\code{\link{S2MART}}
}
\author{
Clement WALTER \email{clementwalter@icloud.com}
}
