% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missar.R
\name{missar}
\alias{missar}
\title{Generate Data that is Missing At Random (MAR)}
\usage{
missar(x, miss.rate = 0.2, miss.var = 1)
}
\arguments{
\item{x}{a matrix to be used to fill in missing values as NA.}

\item{miss.rate}{a value of missing rate within the range (0, 1) for variables that contain missing values.}

\item{miss.var}{proportion of variables (columns) that contain missing values.}
}
\value{
x a matrix with missing values in "NA".
}
\description{
Simulates missing value at random as NA for a given matrix.
}
\examples{

\donttest{
set.seed(0)
data(toxicity, package = "misspi")
toxicity.miss <- missar(toxicity, 0.4, 1)
toxicity.miss[1:5, 1:5]}

}
\seealso{
\code{\link{misspi}}
}
\author{
Zhongli Jiang \email{happycatstat@gmail.com}
}
