% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{call_mirai}
\alias{call_mirai}
\title{mirai (Call Value)}
\usage{
call_mirai(x)
}
\arguments{
\item{x}{(mirai | list) a 'mirai' object or list of 'mirai' objects.}
}
\value{
The passed object (invisibly). For a 'mirai', the retrieved value is
stored at \verb{$data}.
}
\description{
Waits for the 'mirai' to resolve if still in progress (blocking but
user-interruptible), stores the value at \verb{$data}, and returns the 'mirai'
object.
}
\details{
Accepts a list of 'mirai' objects, such as those returned by \code{\link[=mirai_map]{mirai_map()}},
as well as individual 'mirai'.

\code{x[]} may also be used to wait for and return the value of a mirai \code{x}, and
is the equivalent of \code{call_mirai(x)$data}.
}
\section{Alternatively}{


The value of a 'mirai' may be accessed at any time at \verb{$data}, and if yet to
resolve, an 'unresolved' logical NA will be returned instead.

Using \code{\link[=unresolved]{unresolved()}} on a 'mirai' returns TRUE only if it has yet to resolve
and FALSE otherwise. This is suitable for use in control flow statements such
as \code{while} or \code{if}.
}

\section{Errors}{


If an error occurs in evaluation, the error message is returned as a
character string of class 'miraiError' and 'errorValue'. \code{\link[=is_mirai_error]{is_mirai_error()}}
may be used to test for this. The elements of the original condition are
accessible via \code{$} on the error object. A stack trace comprising a list of
calls is also available at \verb{$stack.trace}, and the original condition classes
at \verb{$condition.class}.

If a daemon crashes or terminates unexpectedly during evaluation, an
'errorValue' 19 (Connection reset) is returned.

\code{\link[=is_error_value]{is_error_value()}} tests for all error conditions including 'mirai' errors,
interrupts, and timeouts.
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# using call_mirai()
df1 <- data.frame(a = 1, b = 2)
df2 <- data.frame(a = 3, b = 1)
m <- mirai(as.matrix(rbind(df1, df2)), df1 = df1, df2 = df2, .timeout = 1000)
call_mirai(m)$data

# using unresolved()
m <- mirai(
  {
    res <- rnorm(n)
    res / rev(res)
  },
  n = 1e6
)
while (unresolved(m)) {
  cat("unresolved\n")
  Sys.sleep(0.1)
}
str(m$data)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=race_mirai]{race_mirai()}}
}
