% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_df.R
\name{mi_df}
\alias{mi_df}
\title{Build a multiple instance (MI) data frame}
\usage{
mi_df(
  bag_label = character(),
  bag_name = character(),
  ...,
  instance_label = NULL
)
}
\arguments{
\item{bag_label}{A \code{character}, \code{factor}, or \code{numeric} vector.}

\item{bag_name}{A \code{character} or \code{factor} vector.}

\item{...}{A set of name-value pairs. These construct the covariates for a
\code{mi_df}.}

\item{instance_label}{A \code{character}, \code{factor}, or \code{numeric} vector, or
\code{NULL}.}
}
\value{
A 'mi_df' object. This data.frame-like has columns \code{bag_label},
\code{bag_name}, and those specified in \code{...}. It also inherits from the
\code{'tbl_df'} and \code{'tbl'} classes.
}
\description{
\code{mi_df()} constructs a data frame that corresponds to Multiple Instance (MI)
data.  A \code{mi_df} object must have two special columns:
\itemize{
\item \code{bag_label}, determines the label of each bag, typically from \code{c(0, 1)}
\item \code{bag_name}, character or factor that specifies the bag that each sample
belongs to.
}
}
\details{
We refer to the rows of a \code{mi_df} as \emph{instances}. Each instance is
contained in a bag, with a corresponding label. Bags will typically have
several instances within them. Instance labels can be provided, but they will
be pulled in as an attribute.
}
\examples{
mi_df('bag_label' = factor(c(1, 1, 0)),
      'bag_name' = c(rep('bag_1', 2), 'bag_2'),
      'X1' = c(-0.4, 0.5, 2),
      'instance_label' = c(0, 1, 0))

}
\seealso{
\itemize{
\item \code{\link[=as_mi_df]{as_mi_df()}} to convert data.frames to \code{mi_df}s.
}
}
\author{
Sean Kent
}
