% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{get_bad_ct}
\alias{get_bad_ct}
\title{Gets vector of control terminology which should be there}
\usage{
get_bad_ct(data, metacore, var, na_acceptable = NULL)
}
\arguments{
\item{data}{Data to check}

\item{metacore}{A metacore object to get the codelist from. If the variable
has different codelists for different datasets the metacore object will
need to be subsetted using \code{select_dataset} from the metacore package.}

\item{var}{Name of variable to check}

\item{na_acceptable}{Logical value, set to \code{NULL} by default, so the
acceptability of missing values is based on if the core for the variable is
"Required" in the \code{metacore} object. If set to \code{TRUE} then will pass check
if values are in the control terminology or are missing. If set to
\code{FALSE} then NA will not be acceptable.}
}
\value{
vector
}
\description{
This function checks the column in the dataset only contains the control
terminology as defined by the metacore specification. It will return all
values not found in the control terminology
}
\examples{
library(haven)
library(metacore)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
get_bad_ct(data, spec, "DCSREAS")
get_bad_ct(data, spec, "DCSREAS", na_acceptable = FALSE)

}
