% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTSI.R
\name{mtsi}
\alias{mtsi}
\title{Multi-trait stability index}
\usage{
mtsi(
  .data,
  index = "waasby",
  ideotype = NULL,
  SI = 15,
  mineval = 1,
  verbose = TRUE
)
}
\arguments{
\item{.data}{An object of class \code{waasb} or \code{waas}.}

\item{index}{If \code{index = 'waasby'} (default) both stability and mean
performance are considered. If \code{index = 'waasb'} the multi-trait index
will be computed considering the stability of genotypes only.  More details
can be seen in \code{\link[=waasb]{waasb()}} and \code{\link[=waas]{waas()}} functions.}

\item{ideotype}{A vector of length \code{nvar} where \code{nvar} is the
number of variables used to plan the ideotype. Use \code{'h'} to indicate
the traits in which higher values are desired or \code{'l'} to indicate the
variables in which lower values are desired. For example, \code{ideotype = c("h, h, h, h, l")} will consider that the ideotype has higher values for
the first four traits and lower values for the last trait.}

\item{SI}{An integer (0-100). The selection intensity in percentage of the
total number of genotypes.}

\item{mineval}{The minimum value so that an eigenvector is retained in the
factor analysis.}

\item{verbose}{If \code{verbose = TRUE} (Default) then some results are
shown in the console.}
}
\value{
An object of class \code{mtsi} with the following items:
\itemize{
\item \strong{data} The data used to compute the factor analysis.
\item \strong{cormat} The correlation matrix among the environments.
\item \strong{PCA} The eigenvalues and explained variance.
\item \strong{FA} The factor analysis.
\item \strong{KMO} The result for the Kaiser-Meyer-Olkin test.
\item \strong{MSA} The measure of sampling adequacy for individual variable.
\item \strong{communalities} The communalities.
\item \strong{communalities_mean} The communalities' mean.
\item \strong{initial_loadings} The initial loadings.
\item \strong{finish_loadings} The final loadings after varimax rotation.
\item \strong{canonical_loadings} The canonical loadings.
\item \strong{scores_gen} The scores for genotypes in all retained factors.
\item \strong{scores_ide} The scores for the ideotype in all retained factors.
\item \strong{MTSI} The multi-trait stability index.
\item \strong{contri_fac} The relative contribution of each factor on the MTSI
value. The lower the contribution of a factor, the close of the ideotype the
variables in such factor are.
\item \strong{contri_fac_rank, contri_fac_rank_sel} The rank for the contribution
of each factor for all genotypes and selected genotypes, respectively.
\item \strong{sel_dif_trait, sel_dif_stab, sel_dif_mps} A data frame containing the
selection differential (gains) for the traits, for the stability (WAASB
index) WAASB, and for the mean performance and stability (WAASBY indexes).
The following variables are shown.
\itemize{
\item \code{VAR}: the trait's name.
\item \code{Factor}: The factor that traits where grouped into.
\item \code{Xo}: The original population mean.
\item \code{Xs}: The mean of selected genotypes.
\item \code{SD} and \code{SDperc}: The selection differential and selection differential in
percentage, respectively.
\item \code{h2}: The broad-sense heritability.
\item \code{SG} and \code{SGperc}: The selection gains and selection gains in percentage,
respectively.
\item \code{sense}: The desired selection sense.
\item \code{goal}: selection gains match desired sense? 100 for yes and 0 for no.
}
\item \strong{stat_dif_var, stat_dif_stab, stat_dif_mps} A data frame with the
descriptive statistic for the selection gains for the traits, for the
stability (WAASB index) WAASB, and for the mean performance and stability
(WAASBY index).
The following variables are shown.
\itemize{
\item \code{sense}: The desired selection sense.
\item \code{variable}: the trait's name.
\item \code{min}: the minimum value for the selection gain.
\item \code{mean}: the mean value for the selection gain.
\item \code{ci}: the confidence interval for the selection gain.
\item \code{sd.amo}: the standard deviation for the selection gain.
\item \code{max}: the maximum value for the selection gain.
\item \code{sum}: the sum of the selection gain.
}
\item \strong{sel_gen} The selected genotypes.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Computes the multi-trait stability index proposed by Olivoto et al. (2019)
}
\examples{
\donttest{
library(metan)
# Based on stability only, for both GY and HM, higher is better
mtsi_model <-
    waasb(data_ge,
    env = ENV,
    gen = GEN,
    rep = REP,
    resp = c(GY, HM))
mtsi_index <-
    mtsi(mtsi_model, index = 'waasb')


# Based on mean performance and stability (using pipe operator \%>\%)
# GY: higher is better
# HM: lower is better

mtsi_index2 <-
 data_ge \%>\%
 waasb(ENV, GEN, REP,
       resp = c(GY, HM),
       mresp = c("h, l")) \%>\%
 mtsi()
}
}
\references{
Olivoto, T., A.D.C. Lúcio, J.A.G. da silva, B.G. Sari, and
M.I. Diel. 2019. Mean performance and stability in multi-environment trials
II: Selection based on multiple traits. Agron. J. 111:2961-2969.
\doi{10.2134/agronj2019.03.0220}
}
\seealso{
\code{\link[=mgidi]{mgidi()}}, \code{\link[=waasb]{waasb()}}, \code{\link[=get_model_data]{get_model_data()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
