% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_sum}
\alias{normalize_sum}
\title{Normalize intensities across samples by dividing by the sample sum}
\usage{
normalize_sum(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
Normalize across samples by dividing feature intensities by the sum of all intensities in a sample, making the sum 1 in all samples.

\strong{Important Note}

Intensities of individual features will be very small after this normalization approach. It is therefore advised to multiply all intensities with a fixed number (e.g., 1000) after normalization.
See \href{https://omicsforum.ca/t/sum-normalization-needs-clarification-or-potentially-has-an-issue/3244}{this discussion on OMICSForum.ca} and the examples below
for further information.
}
\examples{
# Example 1: Normalization only
toy_metaboscape \%>\%
  normalize_sum()

# Example 2: Multiply with 1000 after normalization
toy_metaboscape \%>\%
  normalize_sum() \%>\%
  dplyr::mutate(Intensity = .data$Intensity * 1000)
}
