% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_pqn}
\alias{normalize_pqn}
\title{Normalize intensities across samples using a Probabilistic Quotient Normalization (PQN)}
\usage{
normalize_pqn(
  data,
  fn = "median",
  normalize_sum = TRUE,
  reference_samples = NULL,
  ref_as_group = FALSE,
  group_column = NULL
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{fn}{Which function should be used to calculate the reference spectrum from the reference samples? Can be either "mean" or "median".}

\item{normalize_sum}{A logical indicating whether a sum normalization (aka total area normalization) should be performed prior to PQN.
It is \href{https://rdrr.io/github/ricoderks/Rcpm/man/pqn.html}{recommended} to do so and other packages (e.g., \CRANpkg{KODAMA}) also perform a sum normalization prior to PQN.}

\item{reference_samples}{Either \code{NULL} or a character or character vector containing the sample(s)
to calculate the reference spectrum from. In the original publication, it is advised to calculate the median of control samples.
If \code{NULL}, all samples will be used to calculate the reference spectrum.}

\item{ref_as_group}{A logical indicating if \code{reference_samples} are the names of samples or group(s).}

\item{group_column}{Only relevant if \code{ref_as_group = TRUE}. Which column should be used for grouping reference and non-reference samples? Usually \code{group_column = Group}. Uses \code{\link[rlang]{args_data_masking}}.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
This method was originally developed for H-NMR spectra of complex biofluids but has been adapted for other 'omics data. It aims to eliminate
dilution effects by calculating the most probable dilution factor for each sample, relative to one or more reference samples. See references for more details.
}
\examples{
# specify the reference samples with their sample names
toy_metaboscape \%>\%
  impute_lod() \%>\%
  normalize_pqn(reference_samples = c("QC1", "QC2", "QC3"))

# specify the reference samples with their group names
toy_metaboscape \%>\%
  join_metadata(toy_metaboscape_metadata) \%>\%
  impute_lod() \%>\%
  normalize_pqn(reference_samples = c("QC"), ref_as_group = TRUE, group_column = Group)
}
\references{
\itemize{
\item F. Dieterle, A. Ross, G. Schlotterbeck, H. Senn, \emph{Anal. Chem.} \strong{2006}, \emph{78}, 4281–4290, DOI 10.1021/ac051632c.
}
}
