% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{make_spectrum}
\alias{make_spectrum}
\title{Create a Spectrum Object}
\usage{
make_spectrum(
  si,
  cs_max,
  cs_width,
  fq_ref,
  fq_width = NULL,
  force = FALSE,
  silent = FALSE,
  name = NULL,
  path = NULL,
  type = NULL,
  simpar = NULL,
  mfs = NULL
)
}
\arguments{
\item{si}{Numeric vector of signal intensities, ordered from highest to lowest
corresponding chemical shift.}

\item{cs_max}{The highest chemical shift value in ppm, usually shown as left end of the
spectrum.}

\item{cs_width}{The width of the spectrum in ppm.}

\item{fq_ref}{The reference frequency in Hz.}

\item{fq_width}{The width of the spectrum in Hz. Only used to check whether the values
calculated from \code{cs_max}, \code{cs_width} and \code{fq_ref} match the provided value.
If \code{NULL}, this check will be skipped.}

\item{force}{If \code{TRUE}, the function will not raise an error in case of
discrepancies between the calculated and the provided spectrum width in Hz,
but will print a info message instead. To hide this message as well, set
\code{silent = TRUE}.}

\item{silent}{If \code{TRUE}, no output will be printed to the console.}

\item{name}{The name of the spectrum, e.g. "Blood 1" or "Urine Mouse X23D".}

\item{path}{The path to the spectrum file, e.g. "/example_datasets/bruker/urine/urine_1".}

\item{type}{The type of experiment, e.g. "H1 CPMG" or "H1 NOESY".}

\item{simpar}{The simulation parameters used to generate the spectrum.}

\item{mfs}{The magnetic field strength in Tesla.}
}
\value{
A \code{spectrum} object as described in \href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.
}
\description{
Creates a spectrum object from the provided signal intensities, frequencies
and chemical shifts.
}
\examples{
si <- c(1, 1, 3, 7, 8, 3, 8, 5, 2, 1)
cs_max <- 14.8
cs_width <- 20.0
fq_ref <- 600.25 * 1e6
fq_width <- 12005
spectrum <- make_spectrum(si, cs_max, cs_width, fq_ref, fq_width)
spectrum2 <- make_spectrum(si, cs_max, cs_width, fq_ref, fq_width = 12010, force = FALSE)
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
