% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{draw_spectrum}
\alias{draw_spectrum}
\title{Draw Spectrum}
\usage{
draw_spectrum(
  obj,
  foc_rgn = NULL,
  foc_frac = NULL,
  foc_only = TRUE,
  add = FALSE,
  fig_rgn = NULL,
  main = NULL,
  show = TRUE,
  show_d2 = FALSE,
  truepar = NULL,
  mar = c(4.1, 5.1, 1.1, 1.1),
  sf_vert = "auto",
  si_line = list(),
  sm_line = list(),
  sp_line = list(),
  d2_line = list(),
  al_line = list(),
  lc_lines = list(),
  tp_lines = list(),
  al_lines = list(),
  cent_pts = list(),
  bord_pts = list(),
  norm_pts = list(),
  bg_rect = list(),
  foc_rect = list(),
  lc_rects = list(),
  tp_rects = list(),
  bt_axis = list(),
  lt_axis = list(),
  tp_axis = list(),
  rt_axis = list(),
  bt_text = list(),
  lt_text = list(),
  tp_text = list(),
  rt_text = list(),
  tp_verts = list(),
  lc_verts = list(),
  al_verts = list(),
  ze_hline = list(),
  al_arrows = list(),
  lgd = list()
)
}
\arguments{
\item{obj}{An object of type \code{spectrum} or \code{decon2}. For details see \href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.}

\item{foc_rgn}{Numeric vector specifying the start and end of focus region in ppm.}

\item{foc_frac}{Numeric vector specifying the start and end of focus region as fraction of
the full spectrum width.}

\item{foc_only}{Logical. If TRUE, only the focused region is drawn. If FALSE, the full
spectrum is drawn.}

\item{add}{If TRUE, draw into the currently open figure. If FALSE, start a new figure.}

\item{fig_rgn}{Drawing region in normalized device coordinates as vector of the form \code{c(x1, x2, y1, y2)}.}

\item{main}{Main title of the plot. Drawn via \code{\link[=title]{title()}}.}

\item{show}{Logical. If FALSE, the function returns without doing anything.}

\item{show_d2}{Logical. If TRUE, the second derivative of the spectrum is drawn. Setting
this to TRUE changes most of the defaults for the drawing, e.g. by disabling
the drawing of anything related to signal intensities and by changing the
y-axis label to "Second Derivative".}

\item{truepar}{Data frame with columns x0, A and lambda containing the true lorentzian that
were used to simulate the spectrum. Required if any \verb{tp_*} argument is set.}

\item{mar}{Number of lines below/left-of/above/right-of plot region.}

\item{sf_vert}{Scale factor for vertical lines corresponding to \code{lc_verts}, \code{tp_verts} and
\code{al_verts}. If a numeric value is provided, the height of each line equals
the area of the corresponding lorentzian curve multiplied by \code{sf_vert}. In
addition, the following strings are supported:
\itemize{
\item \code{"auto"}: A suitable numeric value for \code{sf_vert} is chosen automatically,
in a way that the highest integral equals the highest signal
intensity after multiplication with \code{sf_vert}.
\item \code{"peak"}: Vertical lines are drawn from bottom to top of the corresponding
peak.
\item \code{"full"}: Vertical lines are drawn over the full vertical range of the plot
region.
}}

\item{si_line, sm_line, sp_line, al_line, d2_line, lc_lines, tp_lines, al_lines}{List  of  parameters  passed  to  \code{\link[=lines]{lines()}}  when  drawing  the
raw signal intensities (si_line),
smoothed signal intensities (sm_line),
superposition of lorentzian curves (sp_line),
aligned lorentzian curves (al_line),
second derivative (d2_line),
lorentzian curves found by deconvolution (lc_lines),
true lorentzian curves (tp_lines) and
aligned lorentzian curves (al_lines),
respectively.}

\item{cent_pts, bord_pts, norm_pts}{List of parameters passed to \code{\link[=points]{points()}} when drawing the peak center  points,
peak border points and non-peak points.}

\item{bg_rect, lc_rects, foc_rect, tp_rects}{List of parameters passed to \code{\link[=rect]{rect()}} when drawing the background, lorentzian
curve substitutes, focus rectangle and/or true lorentzian curve substitutes.}

\item{bt_axis, lt_axis, tp_axis, rt_axis}{List of parameters used to overwrite the default values  passed  to  \code{\link[=axis]{axis()}}
when drawing the bottom, left,  top  and  right  axis.  In  addition  to  the
parameters of \code{\link[=axis]{axis()}}, the following additional parameters are supported  as
well:
\itemize{
\item \code{n}:      Number of tickmarks.
\item \code{digits}: Number of digits for rounding the labels. If a vector of numbers
is provided, all numbers are tried, until \code{n} unique labels are
found. See 'Details'.
\item \code{sf}:     Scaling factor. Axis values are divided by this number before the
labels are calculated. If you set this to anything unequal 1, you
should also set the corresponding margin text in a way that
reflects the scaling. Example: by default, a scaling factor of
1e6 is used for drawing signal intensities and a scaling factor
of 1 for drawing the second derivative. To make clear, that the
user should be careful when interpreting the signal intensity
values, the corresponding margin text is set to "Signal Intensity
[au]"  where "au" means "Arbitrary Units", indicating that the
values might be scaled.
}}

\item{bt_text, lt_text, tp_text, rt_text}{List of parameters used to overwrite the default values passed to \code{\link[=mtext]{mtext()}}
when drawing the bottom, left, top and right margin texts (i.e. the axis
labels).}

\item{lc_verts, tp_verts, al_verts}{List of parameters passed to \code{\link[=segments]{segments()}} when drawing vertical lines at the
centers of estimated, true or aligned lorentzian curves. Setting
\code{tp_verts$show} to TRUE requires \code{truepar} to be set.}

\item{ze_hline}{List of parameters passed to \code{\link[=abline]{abline()}} when drawing a horizontal line at y = 0.}

\item{al_arrows}{List of parameters passed to \code{\link[=arrows]{arrows()}} when drawing arrows between the
estimated and aligned lorentzian curve centers.}

\item{lgd}{List of parameters passed to \code{\link[=legend]{legend()}} when drawing the legend.}
}
\value{
NULL. Called for side effect of plotting.
}
\description{
Draws a single spectrum.  Internally  used  by  \code{\link[=plot_spectrum]{plot_spectrum()}},  which  is
usually  the  recommended  way  to  plot  spectra.  For  usage  examples  see
\href{https://github.com/spang-lab/metabodecon/blob/main/tests/testthat/test-draw_spectrum.R}{test/testthat/test-draw_spectrum.R}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
Parameters \code{bt_axis}, \code{lt_axis}, \code{tp_axis} and \code{rt_axis} all  support  option
\code{n} and \code{digits}, where \code{n = 5} means "Draw 5 tickmarks over  the  full  axis
range" and \code{digits = 3} means "round the label shown beside each tickmark  to
3 digits". If \code{n} or \code{digits} is omitted, a suitable value is chosen
automatically. Providing a vector of \code{digits} causes each digit to be tried
until a digit is encountered that results in \code{n} unique labels. Example:

Assume we have \code{n = 4} and the corresponding  calculated  tickmark  positions
are: 1.02421, 1.02542, 1.02663 and 1.02784. If we provide \code{digits = 1:5}, the
following representations are tried:\tabular{lllll}{
   digit \tab label 1 \tab label 2 \tab label 3 \tab label 4 \cr
   1 \tab 1.0 \tab 1.0 \tab 1.0 \tab 1.0 \cr
   2 \tab 1.02 \tab 1.03 \tab 1.03 \tab 1.03 \cr
   3 \tab 1.024 \tab 1.025 \tab 1.027 \tab 1.028 \cr
   4 \tab 1.0242 \tab 1.0254 \tab 1.0266 \tab 1.0278 \cr
   5 \tab 1.02421 \tab 1.02542 \tab 1.02663 \tab 1.02784 \cr
}


In the above example the process would stop at \code{digit = 3}, because  at  this
point we have n = 4 unique labels (1.024, 1.025, 1.027 and 1.028).
}
\examples{
decon <- deconvolute(sim[[1]], sfr = c(3.55, 3.35))
draw_spectrum(obj = decon)
draw_spectrum(obj = decon, lgd = list(x = "top", bg = NA))
draw_spectrum(obj = decon, foc_rgn = c(3.45, 3.37))
draw_spectrum(obj = decon, add = FALSE, lgd = FALSE,
              fig = c(.2, .8, .2, .4), mar = c( 0,  0,  0,  0))
draw_spectrum(obj = decon, add = TRUE, lgd = FALSE,
              fig = c(0.2, 0.8, 0.6, 0.8), mar = c(0, 0, 0, 0))
draw_spectrum(obj = decon, lc_lines = NULL, lc_rects = NULL, foc_only = FALSE)
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
