% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{combine_peaks}
\alias{combine_peaks}
\title{Combine Peaks}
\usage{
combine_peaks(
  shifted_mat,
  range = 5,
  lower_bound = 1,
  spectrum_data = NULL,
  data_path = NULL
)
}
\arguments{
\item{shifted_mat}{The matrix returned by \code{speaq_align()}.}

\item{range}{Amount of adjacent columns which are permitted to be used for
improving the alignment.}

\item{lower_bound}{Minimum amount of non-zero elements per column to trigger
the alignment improvement.}

\item{spectrum_data}{The list of deconvoluted spectra as returned by
\code{generate_lorentz_curves()} that was used to generate \code{shifted_mat}. No
longer required since version 1.2 of Metabodecon.}

\item{data_path}{If not NULL, the returned dataframes \code{long} and \code{short} are
written to \code{data_path} as "aligned_res_long.csv" and "aligned_res_short.csv".}
}
\value{
A list containing two data frames \code{long} and \code{short}. The first data
frame contains one column for each data point in the original spectrum. The
second data frame contains only columns where at least one entry is non-zero.
}
\description{
Helper function of \code{align()}. Should not be called directly by the user.

Even after calling \code{\link[=speaq_align]{speaq_align()}}, the alignment of individual signals is
not always perfect, as 'speaq' performs a segment-wise alignment i.e. groups
of signals are aligned. For further improvements, partly filled neighboring
columns are merged. See 'Details' for an illustrative example.

Direct usage of this function has been deprecated with metabodecon version
1.4.3 and will be removed with metabodecon version 2.0.0.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
Example of what the function does:

\if{html}{\out{<div class="sourceCode txt">}}\preformatted{|            | 1    | 2    | 3    | 4    | 5    |
|----------- |------|------|------|------|------|
| Spectrum 1 | 0.13 | 0    | 0    | 0.11 | 0    |
| Spectrum 2 | 0    | 0.88 | 0    | 0.12 | 0    |
| Spectrum 3 | 0.07 | 0.56 | 0.30 | 0    | 0    |
| Spectrum 4 | 0.08 | 0    | 0.07 | 0    | 0.07 |
| Spectrum 5 | 0.04 | 0    | 0    | 0.04 | 0    |
}\if{html}{\out{</div>}}

becomes

\if{html}{\out{<div class="sourceCode txt">}}\preformatted{|            | 1    | 2    | 3    | 4    | 5    |
|----------- |------|------|------|------|------|
| Spectrum 1 | 0.13 | 0    | 0    | 0.11 | 0    |
| Spectrum 2 | 0    | 0.88 | 0    | 0.12 | 0    |
| Spectrum 3 | 0.07 | 0.56 | 0    | 0.30 | 0    |
| Spectrum 4 | 0.08 | 0    | 0    | 0.07 | 0.07 |
| Spectrum 5 | 0.04 | 0    | 0    | 0.04 | 0    |
}\if{html}{\out{</div>}}

I.e.
\enumerate{
\item Column 1 and 2 get NOT merged, because they have a common non-zero entry.
\item Column 3 and 4 get merged, because they are in \code{range} of each other and
have no common non-zero entries.
\item Column 4 and 5 get NOT merged, because it is more beneficial to merge
column 3 and 4, as they have more mergeable entries and after merging
column 3 and 4, column 4 and 5 have a common non-zero entry.
}
}
\examples{
deps <- c("MassSpecWavelet", "impute")
deps_installed <- sapply(deps, requireNamespace, quietly = TRUE)
if (all(deps_installed)) {
    # 'speaq' requires 'MassSpecWavelet' and 'impute' to be installed
    sim_subset <- metabodecon_file("bruker/sim_subset")
    spectrum_data <- generate_lorentz_curves_sim(sim_subset)
    shifted_mat <- speaq_align(spectrum_data = spectrum_data, verbose = FALSE)
    range <- 5
    lower_bound <- 1
    obj <- combine_peaks(shifted_mat, range, lower_bound)
    str(obj)
}
}
\author{
2021-2024 Wolfram Gronwald: initial version.\cr 2024-2025 Tobias Schmidt:
refactored initial version.
}
